/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import org.databene.commons.ui.FileChooser;
import org.databene.commons.ui.FileOperation;
import org.databene.commons.ui.FileTypeSupport;

public class SwingFileChooser
extends JFileChooser
implements FileChooser {
    private static final long serialVersionUID = 3258145358496737942L;
    private FileOperation operation;

    public SwingFileChooser(FileTypeSupport supportedTypes, FileOperation operation) {
        this.operation = operation;
        super.setFileSelectionMode(this.fileSelectionMode(supportedTypes));
        super.setDialogType(this.dialogType(operation));
    }

    public File chooseFile(Component component) {
        int approval;
        switch (this.operation) {
            case open: {
                approval = this.showOpenDialog(component);
                break;
            }
            case save: {
                approval = this.showSaveDialog(component);
                break;
            }
            default: {
                approval = this.showDialog(component, "Choose");
            }
        }
        return approval == 0 ? super.getSelectedFile() : null;
    }

    private int dialogType(FileOperation operation) {
        switch (operation) {
            case open: {
                return 0;
            }
            case save: {
                return 1;
            }
        }
        return 2;
    }

    private int fileSelectionMode(FileTypeSupport supportedTypes) {
        switch (supportedTypes) {
            case directoriesOnly: {
                return 1;
            }
            case filesOnly: {
                return 0;
            }
            case filesAndDirectories: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Illegal option: " + supportedTypes);
    }
}

