/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SwingUtil {
    public static void repaintLater(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.repaint();
            }
        });
    }

    public static void center(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - component.getWidth()) / 2;
        int y = (screenSize.height - component.getHeight()) / 2;
        component.setLocation(x, y);
    }

    public static void showInFrame(Component component, String title) {
        JFrame frame = new JFrame(title);
        frame.getContentPane().add(component, "Center");
        frame.pack();
        SwingUtil.center(frame);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static Rectangle fitRectangles(Dimension imageSize, Dimension size) {
        double aspectX = (double)size.width / (double)imageSize.width;
        double aspectY = (double)size.height / (double)imageSize.height;
        double aspect = Math.min(aspectX, aspectY);
        int paintedWidth = (int)((double)imageSize.width * aspect);
        int paintedHeight = (int)((double)imageSize.height * aspect);
        int x = (size.width - paintedWidth) / 2;
        int y = (size.height - paintedHeight) / 2;
        return new Rectangle(x, y, paintedWidth, paintedHeight);
    }

    public static boolean isLookAndFeelNative() {
        return UIManager.getSystemLookAndFeelClassName().equals(UIManager.getLookAndFeel().getClass().getName());
    }
}

