/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.databene.commons.Period;
import org.databene.gui.swing.PeriodComboBox;

public class TimescaleSelector
extends JPanel {
    private static final long serialVersionUID = 4851141632147396863L;
    Period scale;
    private Period minScale;
    private Period maxScale;
    private JComponent component;
    private Listener listener = new Listener();

    public TimescaleSelector(Period scale) {
        this(scale, scale, scale);
    }

    public TimescaleSelector(Period scale, Period minScale, Period maxScale) {
        super(new BorderLayout());
        this.setScale(scale);
        this.setScaleRange(minScale, maxScale);
    }

    public Period getScale() {
        return this.scale;
    }

    public void setScale(Period scale) {
        this.scale = scale;
        if (this.component instanceof PeriodComboBox) {
            ((PeriodComboBox)this.component).setSelectedItem(scale);
        }
    }

    public Period getMinScale() {
        return this.minScale;
    }

    public Period getMaxScale() {
        return this.maxScale;
    }

    public void setScaleRange(Period minScale, Period maxScale) {
        this.removeAll();
        if (this.component instanceof PeriodComboBox) {
            ((PeriodComboBox)this.component).removeActionListener(this.listener);
        }
        this.minScale = minScale;
        this.maxScale = maxScale;
        if (minScale == maxScale) {
            this.component = new JLabel(minScale.getName());
        } else {
            PeriodComboBox comboBox = new PeriodComboBox(minScale, maxScale);
            comboBox.addActionListener(this.listener);
            this.component = comboBox;
        }
        this.add((Component)this.component, "Center");
    }

    class Listener
    implements ActionListener {
        Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            Period selectedPeriod;
            TimescaleSelector.this.scale = selectedPeriod = (Period)((JComboBox)e.getSource()).getSelectedItem();
        }
    }
}

