/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.delegate;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.databene.commons.BeanUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.bean.ObservableBean;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.ui.I18NSupport;

public class PropertyComboBox
extends JComboBox {
    private static final long serialVersionUID = -5039037135360506124L;
    private Object bean;
    private String propertyName;
    boolean locked;

    public PropertyComboBox(Object bean, String propertyName, I18NSupport i18n, String prefix, Object ... values) {
        super(values);
        this.bean = bean;
        this.propertyName = propertyName;
        this.locked = true;
        Listener listener = new Listener();
        if (bean instanceof ObservableBean) {
            ((ObservableBean)bean).addPropertyChangeListener(propertyName, (PropertyChangeListener)listener);
        }
        this.getModel().addListDataListener(listener);
        this.setRenderer(new Renderer(i18n, prefix));
        this.locked = false;
        this.refresh();
    }

    void refresh() {
        if (!this.locked) {
            this.locked = true;
            Object propertyValue = BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName);
            Object selectedItem = this.getSelectedItem();
            if (!NullSafeComparator.equals((Object)selectedItem, (Object)propertyValue)) {
                this.setSelectedItem(propertyValue);
            }
            this.locked = false;
        }
    }

    void update() {
        if (!this.locked) {
            this.locked = true;
            Object propertyValue = BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName);
            Object selectedItem = this.getSelectedItem();
            if (!NullSafeComparator.equals((Object)selectedItem, (Object)propertyValue)) {
                BeanUtil.setPropertyValue((Object)this.bean, (String)this.propertyName, (Object)selectedItem);
            }
            this.locked = false;
        }
    }

    static final class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 8358429951305253637L;
        private ToStringConverter converter = new ToStringConverter();
        private I18NSupport i18n;
        private String prefix;

        public Renderer(I18NSupport i18n, String prefix) {
            this.i18n = i18n;
            this.prefix = prefix;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = this.i18n.getString(this.prefix + this.converter.convert(value));
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }

    class Listener
    implements PropertyChangeListener,
    ListDataListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PropertyComboBox.this.refresh();
        }

        public void contentsChanged(ListDataEvent evt) {
            PropertyComboBox.this.update();
        }

        public void intervalAdded(ListDataEvent evt) {
            PropertyComboBox.this.update();
        }

        public void intervalRemoved(ListDataEvent evt) {
            PropertyComboBox.this.update();
        }
    }
}

