/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.delegate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.databene.commons.BeanUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.bean.ObservableBean;
import org.databene.commons.ui.FileOperation;
import org.databene.commons.ui.FileTypeSupport;
import org.databene.gui.swing.FileField;

public class PropertyFileField
extends FileField {
    private static final long serialVersionUID = -3970525222511845399L;
    private Object bean;
    private String propertyName;
    boolean locked;

    public PropertyFileField(Object bean, String propertyName, int length, FileTypeSupport typeSupport, FileOperation operation) {
        super(length, null, typeSupport, operation);
        this.init(bean, propertyName);
    }

    public PropertyFileField(Object bean, String propertyName, int length, FileTypeSupport typeSupport, String approveButtonText) {
        super(length, null, typeSupport, approveButtonText);
        this.init(bean, propertyName);
    }

    private void init(Object bean, String propertyName) {
        this.bean = bean;
        this.propertyName = propertyName;
        this.locked = true;
        this.refresh();
        Listener listener = new Listener();
        if (bean instanceof ObservableBean) {
            ((ObservableBean)bean).addPropertyChangeListener(propertyName, (PropertyChangeListener)listener);
        }
        this.addActionListener(listener);
        this.locked = false;
        this.setFile((File)BeanUtil.getPropertyValue((Object)bean, (String)propertyName));
    }

    void refresh() {
        if (!this.locked) {
            this.locked = true;
            Object propertyValue = BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName);
            File file = (File)propertyValue;
            if (!NullSafeComparator.equals((Object)this.getFile(), (Object)file)) {
                this.setFile(file);
            }
            this.locked = false;
        }
    }

    void update() {
        if (!this.locked) {
            this.locked = true;
            File file = this.getFile();
            if (!NullSafeComparator.equals((Object)file, (Object)BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName))) {
                BeanUtil.setPropertyValue((Object)this.bean, (String)this.propertyName, (Object)file);
            }
            this.locked = false;
        }
    }

    class Listener
    implements PropertyChangeListener,
    ActionListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PropertyFileField.this.refresh();
        }

        public void actionPerformed(ActionEvent evt) {
            PropertyFileField.this.update();
        }
    }
}

