/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.databene.gui.swing.ColorUtil;

public class ShadowTableCellRenderer
implements TableCellRenderer {
    public static final Color DEFAULT_ALTERNATIVE_COLOR = new Color(222, 255, 255);
    private TableCellRenderer realRenderer;
    private Color alternativeColor;

    public ShadowTableCellRenderer(TableCellRenderer subject) {
        this(subject, DEFAULT_ALTERNATIVE_COLOR);
    }

    public ShadowTableCellRenderer(TableCellRenderer realRenderer, Color alternativeColor) {
        this.realRenderer = realRenderer;
        this.alternativeColor = alternativeColor;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component renderer;
        if (this.realRenderer instanceof Component) {
            ((Component)((Object)this.realRenderer)).setBackground(table.getBackground());
        }
        if ((renderer = this.realRenderer.getTableCellRendererComponent(table, value, false, hasFocus, row, column)) instanceof JComponent) {
            ((JComponent)renderer).setBorder(new EmptyBorder(3, 4, 4, 2));
        }
        if (isSelected) {
            renderer.setBackground(ColorUtil.adaptBrightness(renderer.getBackground(), 0.85));
        } else if (this.alternativeColor != null && row % 2 == 1 && table.getBackground().equals(renderer.getBackground())) {
            renderer.setBackground(this.alternativeColor);
        }
        return renderer;
    }
}

