/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.edit;

import java.awt.Component;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class DateCellEditor
extends DefaultCellEditor {
    private DateFormat df;
    private Class type;

    public DateCellEditor() {
        this(DateFormat.getInstance(), Date.class);
    }

    public DateCellEditor(String pattern) {
        this(pattern, Date.class);
    }

    private DateCellEditor(DateFormat dateFormat) {
        this(dateFormat, Date.class);
    }

    private DateCellEditor(String pattern, Class type) {
        this(new SimpleDateFormat(pattern), type);
    }

    private DateCellEditor(DateFormat dateFormat, Class type) {
        super(new JTextField());
        this.df = dateFormat;
        this.type = type;
    }

    public static DateCellEditor createDateEditor() {
        return new DateCellEditor(DateFormat.getDateInstance());
    }

    public static DateCellEditor createDateEditor(String pattern) {
        return new DateCellEditor(pattern);
    }

    public static DateCellEditor createLongDateEditor(String pattern) {
        return new DateCellEditor(pattern, Long.class);
    }

    public Object getCellEditorValue() {
        try {
            JTextField field = (JTextField)this.getComponent();
            String text = field.getText();
            if (text.length() == 0) {
                return null;
            }
            Date date = this.df.parse(text);
            if (Date.class.equals((Object)this.type)) {
                return date;
            }
            if (Long.class.equals((Object)this.type)) {
                return new Long(date.getTime());
            }
            throw new RuntimeException("unsupported type: " + this.type);
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this.getComponent(), "Unzul\ufffdssiges Datum", "Fehler", 0);
            throw new RuntimeException(e);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String text = null;
        if (value != null) {
            text = this.df.format((Date)value);
        }
        return super.getTableCellEditorComponent(table, text, isSelected, row, column);
    }
}

