/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.databene.commons.Accessor;
import org.databene.commons.Mutator;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.accessor.AccessingComparator;
import org.databene.gui.swing.table.ShadowTableCellRenderer;
import org.databene.gui.swing.table.item.ConnectorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldConnector<C, V> {
    private String displayName;
    private Accessor<C, V> accessor;
    private TableCellRenderer renderer;
    private Mutator<C, V> mutator;
    private TableCellEditor editor;
    private Comparator comparator;
    private List<ConnectorListener> listeners = new ArrayList<ConnectorListener>();

    public FieldConnector(String displayName, Accessor<C, V> accessor, TableCellRenderer renderer, Mutator<C, V> mutator, TableCellEditor editor, Comparator comparator) {
        this.displayName = displayName;
        this.accessor = accessor;
        this.renderer = new ShadowTableCellRenderer(renderer);
        this.mutator = mutator;
        this.editor = editor;
        this.comparator = new AccessingComparator(this.accessor, comparator);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    public TableCellEditor getEditor() {
        return this.editor;
    }

    public void setEditor(TableCellEditor editor) {
        this.editor = editor;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public V getValueFor(C item) {
        return (V)this.accessor.getValue(item);
    }

    public void setValueFor(C item, V value) {
        try {
            this.mutator.setValue(item, value);
        }
        catch (UpdateFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public void addConnectorListener(ConnectorListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectorListener(ConnectorListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireColumnChanged(FieldConnector column) {
        for (ConnectorListener listener : this.listeners) {
            listener.connectorChanged(column);
        }
    }
}

