/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.databene.gui.swing.table.item.ItemModel;
import org.databene.gui.swing.table.item.ItemSelectionEvent;
import org.databene.gui.swing.table.item.ItemSelectionListener;
import org.databene.gui.swing.table.item.adapter.ConnectorColumnTable;

public class ItemTable
extends JComponent {
    protected ConnectorColumnTable table;
    private List listSelectionListeners = new ArrayList();

    public ItemTable() {
        this(null);
    }

    public ItemTable(ItemModel model) {
        this.setLayout(new BorderLayout());
        this.table = new ConnectorColumnTable(model);
        this.table.getSelectionModel().addListSelectionListener(new Listener());
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public void setModel(ItemModel model) {
        this.table.setItemModel(model);
    }

    public ItemModel getModel() {
        return this.table.getItemModel();
    }

    public Object itemAtPoint(int x, int y) {
        return this.getItemListModel().getElementAt(this.table.rowAtPoint(new Point(x, y)));
    }

    public List getSelectedItems() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int fromIndex = selectionModel.getMinSelectionIndex();
        int toIndex = selectionModel.getMaxSelectionIndex();
        return ItemTable.copy(this.getItemListModel(), fromIndex, toIndex);
    }

    public void setSelectedItems(List list) {
        for (int i = 0; i < list.size(); ++i) {
            int index = this.indexOf(list.get(i));
            this.table.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void setSelectedItem(Object item) {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.clearSelection();
        int index = this.indexOf(item);
        selectionModel.addSelectionInterval(index, index);
    }

    public void addItemSelectionListener(ItemSelectionListener listener) {
        this.listSelectionListeners.add(listener);
    }

    public void removeItemSelectionListener(ItemSelectionListener listener) {
        this.listSelectionListeners.remove(listener);
    }

    protected void fireSelectionChanged() {
        ItemSelectionEvent event = new ItemSelectionEvent(this, this.getSelectedItems());
        for (int i = 0; i < this.listSelectionListeners.size(); ++i) {
            ItemSelectionListener listener = (ItemSelectionListener)this.listSelectionListeners.get(i);
            listener.selectionChanged(event);
        }
    }

    private ListModel getItemListModel() {
        return this.table.getItemModel().getItems();
    }

    private int indexOf(Object item) {
        ListModel listModel = this.getItemListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object test = listModel.getElementAt(i);
            if (!test.equals(item)) continue;
            return i;
        }
        return -1;
    }

    protected void setColumnHeaderRenderer(int column, TableCellRenderer renderer) {
        this.table.getColumnModel().getColumn(column).setHeaderRenderer(renderer);
    }

    protected JTableHeader getTableHeader() {
        return this.table.getTableHeader();
    }

    protected JTable getJTable() {
        return this.table;
    }

    private static List copy(ListModel src, int fromIndex, int toIndex) {
        int size = fromIndex >= 0 && toIndex >= 0 ? toIndex - fromIndex + 1 : 0;
        ArrayList dst = new ArrayList(size);
        for (int i = fromIndex; i <= toIndex && fromIndex >= 0 && toIndex >= 0; ++i) {
            dst.add(src.getElementAt(i));
        }
        return dst;
    }

    class Listener
    implements ListSelectionListener {
        Listener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ItemTable.this.fireSelectionChanged();
        }
    }
}

