/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item.adapter;

import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.databene.gui.swing.table.item.FieldConnector;
import org.databene.gui.swing.table.item.ItemModel;
import org.databene.gui.swing.table.item.adapter.ItemColumn;

public class ItemColumnModel
extends DefaultTableColumnModel
implements ListDataListener {
    private ItemModel itemModel;
    private FieldConnector headerConnector;

    public ItemColumnModel(ItemModel itemModel, FieldConnector headerConnector) {
        this.setItemModel(itemModel, headerConnector);
    }

    public void setItemModel(ItemModel itemModel, FieldConnector headerConnector) {
        ListModel oldListModel;
        if (itemModel != null && (oldListModel = itemModel.getItems()) != null) {
            oldListModel.removeListDataListener(this);
        }
        this.itemModel = itemModel;
        if (itemModel != null && this.itemModel.getItems() != null) {
            this.itemModel.getItems().addListDataListener(this);
        }
        this.headerConnector = headerConnector;
        this.rebuildColumns();
    }

    private void rebuildColumns() {
        for (int i = this.tableColumns.size() - 1; i >= 0; --i) {
            TableColumn tableColumn = (TableColumn)this.tableColumns.get(i);
            this.removeColumn(tableColumn);
        }
        if (this.itemModel != null) {
            TableColumn firstColumn = new TableColumn();
            firstColumn.setHeaderValue("");
            super.addColumn(firstColumn);
            for (int i = 0; i < this.itemModel.getItems().getSize(); ++i) {
                Object item = this.itemModel.getItems().getElementAt(i);
                this.addItem(item, i + 1);
            }
        }
    }

    private void addItem(Object item, int i) {
        String title = this.headerConnector != null ? (String)this.headerConnector.getValueFor(item) : null;
        ItemColumn tColumn = new ItemColumn(i, 50, this.itemModel.getConnectors());
        super.addColumn(tColumn);
        this.fireColumnAdded(new TableColumnModelEvent(this, i, i));
    }

    private void removeItem(Object item, int i) {
        String title = this.headerConnector != null ? (String)this.headerConnector.getValueFor(item) : null;
        ItemColumn tColumn = new ItemColumn(i, 50, this.itemModel.getItems());
        super.removeColumn(tColumn);
        this.fireColumnRemoved(new TableColumnModelEvent(this, i, i));
    }

    public void intervalAdded(ListDataEvent e) {
        for (int i = e.getIndex0(); i < e.getIndex1(); ++i) {
            this.addItem(this.itemModel.getItems().getElementAt(i), i);
        }
    }

    public void intervalRemoved(ListDataEvent e) {
        for (int i = e.getIndex0(); i < e.getIndex1(); ++i) {
            this.removeItem(this.itemModel.getItems().getElementAt(i), i);
        }
    }

    public void contentsChanged(ListDataEvent e) {
        this.rebuildColumns();
    }

    public int getColumnCount() {
        return super.getColumnCount();
    }
}

