/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.render;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.databene.commons.NumberUtil;

public class PercentageTableCellRenderer
extends DefaultTableCellRenderer {
    private Color GREEN = new Color(0, 192, 0);
    private int fractionDigits;

    public PercentageTableCellRenderer() {
        this(0);
    }

    public PercentageTableCellRenderer(int fractionDigits) {
        this.fractionDigits = fractionDigits;
        this.setHorizontalAlignment(4);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = "0";
        double number = 0.0;
        if (value != null) {
            number = ((Number)value).doubleValue();
            text = NumberUtil.format((double)(number * 100.0), (int)this.fractionDigits) + "%";
        }
        Component component = super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        if (number > 0.0) {
            component.setForeground(this.GREEN);
        } else if (number < 0.0) {
            component.setForeground(Color.RED);
        } else {
            component.setForeground(Color.BLACK);
        }
        return component;
    }
}

