/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import java.io.Writer;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.ToStringConverter;
import org.databene.document.csv.CSVUtil;
import org.databene.script.AbstractScript;
import org.databene.script.ConstantScript;
import org.databene.script.Script;
import org.databene.script.ScriptException;
import org.databene.script.ScriptUtil;
import org.databene.script.ScriptedDocumentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCSVWriter<E>
extends ScriptedDocumentWriter<E[]> {
    public ArrayCSVWriter(Writer out) {
        this(out, ',');
    }

    public ArrayCSVWriter(Writer out, char separator) {
        this(out, separator, (Script)null, (Script)null);
    }

    public ArrayCSVWriter(Writer out, char separator, String ... columnHeads) {
        this(out, separator, (Script)new ConstantScript(CSVUtil.formatHeader(separator, columnHeads)), null);
    }

    public ArrayCSVWriter(Writer out, char separator, String headerScriptUrl, String footerScriptUrl) throws IOException {
        this(out, separator, headerScriptUrl != null ? ScriptUtil.readFile(headerScriptUrl) : null, footerScriptUrl != null ? ScriptUtil.readFile(footerScriptUrl) : null);
    }

    public ArrayCSVWriter(Writer out, char separator, Script headerScript, Script footerScript) {
        super(out, headerScript, new ArrayCSVScript(separator), footerScript);
    }

    private static class ArrayCSVScript
    extends AbstractScript {
        private Converter<Object, String> converter;
        private char separator;

        public ArrayCSVScript(char separator) {
            this.separator = separator;
            this.converter = new ToStringConverter();
        }

        public void execute(Context context, Writer out) throws IOException, ScriptException {
            try {
                Object[] cellsOfCurrentRow = (Object[])context.get("part");
                String text = (String)this.converter.convert(cellsOfCurrentRow[0]);
                out.write(CSVUtil.renderCell(text, this.separator));
                for (int i = 1; i < cellsOfCurrentRow.length; ++i) {
                    out.write(this.separator);
                    out.write((String)this.converter.convert(cellsOfCurrentRow[i]));
                }
                out.write(SystemInfo.getLineSeparator());
            }
            catch (ConversionException e) {
                throw new ScriptException(e);
            }
        }
    }
}

