/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import java.util.ArrayList;
import org.databene.commons.ArrayFormat;
import org.databene.commons.SystemInfo;
import org.databene.document.csv.CSVLineIterator;

public class CSVUtil {
    public static String[][] parseRows(String url, char separator) throws IOException {
        return CSVUtil.parseRows(url, separator, SystemInfo.getFileEncoding());
    }

    public static String[][] parseRows(String url, char separator, String encoding) throws IOException {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        CSVLineIterator iterator = new CSVLineIterator(url, separator, encoding);
        while (iterator.hasNext()) {
            lines.add(iterator.next());
        }
        iterator.close();
        String[][] result = new String[lines.size()][];
        return (String[][])lines.toArray((T[])result);
    }

    public static String renderCell(String text, char separator) {
        if (text.indexOf(separator) < 0) {
            return text;
        }
        text = text.replace("\"", "\"\"");
        return '\"' + text + '\"';
    }

    public static String formatHeader(char separator, String ... propertyNames) {
        return ArrayFormat.format((String)String.valueOf(separator), (Object[])propertyNames) + SystemInfo.getLineSeparator();
    }
}

