/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterator;
import org.databene.document.csv.CSVLineIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingCSVParser<E>
implements HeavyweightIterator<E> {
    private Converter<String[], E> rowConverter;
    private CSVLineIterator source;

    public ConvertingCSVParser(String uri, Converter<String[], E> rowConverter) throws IOException {
        this.source = new CSVLineIterator(uri);
        this.rowConverter = rowConverter;
    }

    public boolean hasNext() {
        return this.source.hasNext();
    }

    public E next() {
        return (E)this.rowConverter.convert((Object)this.source.next());
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    public void close() {
        this.source.close();
    }

    public static <T> List<T> parse(String uri, Converter<String[], T> rowConverter) throws IOException {
        return ConvertingCSVParser.parse(uri, rowConverter, new ArrayList());
    }

    public static <T> List<T> parse(String uri, Converter<String[], T> rowConverter, List<T> list) throws IOException {
        ConvertingCSVParser<T> parser = new ConvertingCSVParser<T>(uri, rowConverter);
        while (parser.hasNext()) {
            list.add(parser.next());
        }
        return list;
    }
}

