/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.flat;

import java.io.IOException;
import java.io.Writer;
import java.text.Format;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.SystemInfo;
import org.databene.commons.bean.BeanToPropertyArrayConverter;
import org.databene.commons.converter.ArrayConverter;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.FormatFormatConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.format.PadFormat;
import org.databene.document.flat.FlatFileColumnDescriptor;
import org.databene.script.AbstractScript;
import org.databene.script.Script;
import org.databene.script.ScriptException;
import org.databene.script.ScriptUtil;
import org.databene.script.ScriptedDocumentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFlatFileWriter<E>
extends ScriptedDocumentWriter<E> {
    public BeanFlatFileWriter(Writer out, FlatFileColumnDescriptor ... descriptors) {
        this(out, (Script)null, (Script)null, descriptors);
    }

    public BeanFlatFileWriter(Writer out, String headerScriptUrl, String footerScriptUrl, FlatFileColumnDescriptor ... descriptors) throws IOException {
        this(out, headerScriptUrl != null ? ScriptUtil.readFile(headerScriptUrl) : null, footerScriptUrl != null ? ScriptUtil.readFile(footerScriptUrl) : null, descriptors);
    }

    public BeanFlatFileWriter(Writer out, Script headerScript, Script footerScript, FlatFileColumnDescriptor ... descriptors) {
        super(out, headerScript, new BeanFlatFileScript(descriptors), footerScript);
    }

    private static class BeanFlatFileScript
    extends AbstractScript {
        private Converter<Object, String[]> converter;

        public BeanFlatFileScript(FlatFileColumnDescriptor[] descriptors) {
            int length = descriptors.length;
            String[] propertyNames = new String[length];
            Converter[] propertyConverters = new Converter[length];
            for (int i = 0; i < length; ++i) {
                FlatFileColumnDescriptor descriptor = descriptors[i];
                propertyNames[i] = descriptor.getName();
                propertyConverters[i] = new ConverterChain(new Converter[]{new ToStringConverter(), new FormatFormatConverter(String.class, (Format)new PadFormat(descriptor.getWidth(), descriptor.getAlignment(), ' '))});
            }
            this.converter = new ConverterChain(new Converter[]{new BeanToPropertyArrayConverter(propertyNames), new ArrayConverter(Object.class, String.class, propertyConverters)});
        }

        public void execute(Context context, Writer out) throws IOException, ScriptException {
            try {
                String[] cells = (String[])this.converter.convert(context.get("part"));
                for (int i = 0; i < cells.length; ++i) {
                    out.write(cells[i]);
                }
                out.write(SystemInfo.getLineSeparator());
            }
            catch (ConversionException e) {
                throw new ScriptException(e);
            }
        }
    }
}

