/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.flat;

import org.databene.commons.format.Alignment;
import org.databene.commons.format.PadFormat;

public class FlatFileColumnDescriptor {
    private String name;
    private PadFormat format;

    public FlatFileColumnDescriptor(int width, Alignment alignment) {
        this(null, width, alignment, ' ');
    }

    public FlatFileColumnDescriptor(String name, int width, Alignment alignment) {
        this(name, width, alignment, ' ');
    }

    public FlatFileColumnDescriptor(int width, Alignment alignment, char padChar) {
        this(null, width, alignment, padChar);
    }

    public FlatFileColumnDescriptor(String name, int width, Alignment alignment, char padChar) {
        this.name = name;
        this.format = new PadFormat(width, alignment, padChar);
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.format.getLength();
    }

    public Alignment getAlignment() {
        return this.format.getAlignment();
    }

    public char getPadChar() {
        return this.format.getPadChar();
    }

    public PadFormat getFormat() {
        return this.format;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlatFileColumnDescriptor other = (FlatFileColumnDescriptor)obj;
        if (this.format == null ? other.format != null : !this.format.equals((Object)other.format)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name + '[' + this.format.getLength() + this.format.getAlignment().getId() + this.format.getPadChar() + ']';
    }
}

