/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.flat;

import java.text.NumberFormat;
import java.text.ParsePosition;
import org.databene.commons.ConfigurationError;
import org.databene.commons.StringUtil;
import org.databene.commons.format.Alignment;
import org.databene.document.flat.FlatFileColumnDescriptor;

public class FlatFileUtil {
    public static FlatFileColumnDescriptor[] parseProperties(String properties) {
        if (properties == null) {
            return null;
        }
        String[] propertyFormats = StringUtil.tokenize((String)properties, (char)',');
        FlatFileColumnDescriptor[] descriptors = new FlatFileColumnDescriptor[propertyFormats.length];
        for (int i = 0; i < propertyFormats.length; ++i) {
            String propertyFormat = propertyFormats[i];
            int lbIndex = propertyFormat.indexOf(91);
            if (lbIndex < 0) {
                throw new ConfigurationError("'[' expected in property format descriptor '" + propertyFormat + "'");
            }
            int rbIndex = propertyFormat.indexOf(93);
            if (rbIndex < 0) {
                throw new ConfigurationError("']' expected in property format descriptor '" + propertyFormat + "'");
            }
            String propertyName = propertyFormat.substring(0, lbIndex);
            ParsePosition pos = new ParsePosition(lbIndex + 1);
            int width = NumberFormat.getInstance().parse(propertyFormat, pos).intValue();
            Alignment alignment = Alignment.LEFT;
            if (pos.getIndex() < rbIndex) {
                char alignmentCode = propertyFormat.charAt(pos.getIndex());
                switch (alignmentCode) {
                    case 'l': {
                        alignment = Alignment.LEFT;
                        break;
                    }
                    case 'r': {
                        alignment = Alignment.RIGHT;
                        break;
                    }
                    case 'c': {
                        alignment = Alignment.CENTER;
                        break;
                    }
                    default: {
                        throw new ConfigurationError("Illegal alignment code '" + alignmentCode + "' in property format descriptor '" + propertyFormat + "'");
                    }
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            char padChar = ' ';
            if (pos.getIndex() < rbIndex) {
                padChar = propertyFormat.charAt(pos.getIndex());
                pos.setIndex(pos.getIndex() + 1);
            }
            assert (pos.getIndex() == rbIndex);
            descriptors[i] = new FlatFileColumnDescriptor(propertyName, width, alignment, padChar);
        }
        return descriptors;
    }
}

