/*
 * Decompiled with CFR 0.152.
 */
package org.databene.html;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.CharSet;
import org.databene.html.HTMLTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHTMLTokenizer
implements HTMLTokenizer {
    private static Log logger = LogFactory.getLog(DefaultHTMLTokenizer.class);
    private static final CharSet ELEMENT_NAME_CHARS = new CharSet('A', 'Z').addRange('a', 'z').addRange('0', '9').add('_').add(':');
    private static final CharSet ATTR_NAME_CHARS = new CharSet('A', 'Z').addRange('a', 'z').addRange('0', '9').add('_').add('-').add(':');
    private PushbackReader reader;
    private boolean script;
    private int tokenType;
    private int cursor;
    private String text;
    private int nameStart;
    private int nameLength;
    private String name;
    private int attribCount;
    private Map<String, String> attributeMap;
    private char[] textBuffer;
    private int[] attribNameFrom = new int[256];
    private int[] attribNameUntil = new int[256];
    private int[] attribValueFrom = new int[256];
    private int[] attribValueUntil = new int[256];

    public DefaultHTMLTokenizer(Reader reader) {
        this.textBuffer = new char[65536];
        this.attribNameFrom = new int[256];
        this.attribNameUntil = new int[256];
        this.attribValueFrom = new int[256];
        this.attribValueUntil = new int[256];
        this.reader = new PushbackReader(reader, 256);
        this.script = false;
    }

    @Override
    public int nextToken() throws IOException, ParseException {
        this.cursor = 0;
        this.nameStart = -1;
        this.nameLength = 0;
        this.name = null;
        this.text = null;
        this.attributeMap = null;
        this.attribCount = 0;
        if (this.tokenType == -1) {
            return -1;
        }
        if (this.script) {
            this.parseScript();
        } else {
            int nextChar = DefaultHTMLTokenizer.peek(this.reader);
            switch (nextChar) {
                case -1: {
                    this.tokenType = -1;
                    break;
                }
                case 60: {
                    this.reader.read();
                    int c = DefaultHTMLTokenizer.peek(this.reader);
                    if (Character.isLetter(c) || c == 33 || c == 63 | c == 47) {
                        this.reader.unread(nextChar);
                        this.parseTag();
                        break;
                    }
                    this.reader.unread(nextChar);
                    this.parseText();
                    break;
                }
                default: {
                    this.parseText();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.text());
            }
        }
        return this.tokenType;
    }

    @Override
    public int tokenType() {
        return this.tokenType;
    }

    @Override
    public String name() {
        if (this.name == null && this.nameStart >= 0) {
            this.name = new String(this.textBuffer, this.nameStart, this.nameLength).intern();
        }
        return this.name;
    }

    @Override
    public String text() {
        if (this.text == null) {
            this.text = new String(this.textBuffer, 0, this.cursor);
        }
        return this.text;
    }

    @Override
    public Map<String, String> attributes() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, String>();
            for (int i = 0; i < this.attribCount; ++i) {
                String attribName = new String(this.textBuffer, this.attribNameFrom[i], this.attribNameUntil[i] - this.attribNameFrom[i]);
                attribName = attribName.intern();
                String attribValue = null;
                if (this.attribValueFrom[i] >= 0) {
                    attribValue = new String(this.textBuffer, this.attribValueFrom[i], this.attribValueUntil[i] - this.attribValueFrom[i]);
                }
                this.attributeMap.put(attribName, attribValue);
            }
        }
        return this.attributeMap;
    }

    private void parseScript() throws IOException {
        this.readUntil("</script>", false, false);
        this.script = false;
        this.tokenType = 7;
    }

    private void parseTag() throws IOException, ParseException {
        this.assertChar('<');
        switch (DefaultHTMLTokenizer.peek(this.reader)) {
            case 33: {
                this.assertChar('!');
                if (DefaultHTMLTokenizer.peek(this.reader) == 45) {
                    this.assertChar('-');
                    this.assertChar('-');
                    this.readUntil("-->", true);
                    this.tokenType = 5;
                    break;
                }
                this.parseElementName();
                this.readUntil('>');
                this.assertChar('>');
                this.tokenType = 0;
                break;
            }
            case 47: {
                this.assertChar('/');
                this.parseElementName();
                this.expectChar('>');
                this.tokenType = 3;
                break;
            }
            case 63: {
                this.assertChar('?');
                this.parseElementName();
                this.parseAttributes();
                this.assertChar('?');
                this.assertChar('>');
                this.tokenType = 6;
                break;
            }
            default: {
                this.parseElementName();
                this.parseAttributes();
                this.skipWhitespace();
                if (DefaultHTMLTokenizer.peek(this.reader) == 47) {
                    this.assertChar('/');
                    this.tokenType = 4;
                } else {
                    this.tokenType = 2;
                }
                this.expectChar('>');
                if (!"SCRIPT".equalsIgnoreCase(this.name())) break;
                this.script = true;
            }
        }
    }

    private void parseAttributes() throws IOException, ParseException {
        while (this.parseAttribute()) {
        }
        this.readUntilOneOf("?/>");
    }

    private void parseElementName() throws IOException {
        this.nameStart = this.cursor;
        this.parseString(ELEMENT_NAME_CHARS);
        this.nameLength = this.cursor - this.nameStart;
    }

    private boolean parseAttribute() throws IOException, ParseException {
        this.skipWhitespace();
        this.attribNameFrom[this.attribCount] = this.cursor;
        if (!this.parseAttributeName()) {
            return false;
        }
        this.attribNameUntil[this.attribCount] = this.cursor;
        this.skipWhitespace();
        if (DefaultHTMLTokenizer.peek(this.reader) == 61) {
            this.parseAttributeValueAssignment();
        } else {
            this.attribValueFrom[this.attribCount] = -1;
            this.attribValueUntil[this.attribCount] = -1;
        }
        ++this.attribCount;
        return true;
    }

    private void parseAttributeValueAssignment() throws IOException, ParseException {
        this.assertChar('=', true);
        this.skipWhitespace();
        this.parseAttributeValue();
    }

    private void parseAttributeValue() throws IOException, ParseException {
        int c = DefaultHTMLTokenizer.peek(this.reader);
        if (c == 39 || c == 34) {
            char quoteChar = (char)c;
            this.textBuffer[this.cursor++] = (char)c;
            this.parseQuotedAttributeValue(String.valueOf(quoteChar));
        } else {
            this.attribValueFrom[this.attribCount] = this.cursor;
            this.readUntilOneOf(" >");
            this.attribValueUntil[this.attribCount] = this.cursor;
        }
    }

    private void parseQuotedAttributeValue(String quoteChars) throws IOException, ParseException {
        int quoteChar = this.reader.read();
        this.attribValueFrom[this.attribCount] = this.cursor;
        if (quoteChars.indexOf(quoteChar) < 0) {
            throw new ParseException("Expected quotation like " + quoteChars + ", found: " + quoteChar, 0);
        }
        this.readUntil((char)quoteChar);
        this.attribValueUntil[this.attribCount] = this.cursor;
        this.assertChar((char)quoteChar);
    }

    private boolean parseAttributeName() throws IOException {
        return this.parseString(ATTR_NAME_CHARS);
    }

    private boolean parseString(CharSet charSet) throws IOException {
        int c;
        boolean stringFound = false;
        while ((c = this.reader.read()) != -1 && charSet.contains((char)c)) {
            this.textBuffer[this.cursor++] = (char)c;
            stringFound = true;
        }
        if (c != -1) {
            this.reader.unread(c);
        }
        return stringFound;
    }

    private void parseText() throws IOException {
        this.tokenType = 1;
        boolean end = false;
        do {
            this.readUntil('<');
            int c = this.reader.read();
            if (c == -1) {
                end = true;
                continue;
            }
            if (c == 60) {
                int next = this.reader.read();
                if (next == 47 || next == 33 || next == 63 || Character.isLetter(next)) {
                    this.reader.unread(next);
                    this.reader.unread(c);
                    end = true;
                    continue;
                }
                this.textBuffer[this.cursor++] = (char)c;
                this.textBuffer[this.cursor++] = (char)next;
                continue;
            }
            throw new RuntimeException("Unexpected token: " + (char)c);
        } while (!end);
    }

    public void readUntil(String endText) throws IOException {
        this.readUntil(endText, false);
    }

    public void readUntil(String delimiter, boolean includeDelimiter) throws IOException {
        this.readUntil(delimiter, true, includeDelimiter);
    }

    public void readUntil(String delimiter, boolean caseSensitive, boolean includeDelimiter) throws IOException {
        String cmp = caseSensitive ? delimiter : delimiter.toUpperCase();
        char[] endChars = new char[cmp.length()];
        cmp.getChars(0, delimiter.length(), endChars, 0);
        while (true) {
            int i;
            int c;
            if ((c = this.reader.read()) != -1 && (caseSensitive ? c : Character.toUpperCase(c)) != endChars[0]) {
                this.textBuffer[this.cursor++] = (char)c;
                continue;
            }
            if (c == -1) {
                return;
            }
            int tmpCursor = this.cursor;
            this.textBuffer[tmpCursor++] = (char)c;
            if (endChars.length == 1) {
                if (includeDelimiter) {
                    ++this.cursor;
                } else {
                    this.reader.unread(c);
                }
                return;
            }
            for (i = 1; i < endChars.length; ++i) {
                c = this.reader.read();
                this.textBuffer[tmpCursor++] = (char)c;
                if ((caseSensitive ? c : Character.toUpperCase(c)) == endChars[i]) continue;
                this.cursor += i + 1;
                break;
            }
            if (i == delimiter.length()) break;
        }
        if (includeDelimiter) {
            this.cursor += endChars.length;
        } else {
            this.reader.unread(this.textBuffer, this.cursor, delimiter.length());
        }
    }

    private int readUntilOneOf(String delimiters) throws IOException {
        int c;
        while ((c = this.reader.read()) != -1 && delimiters.indexOf(c) < 0) {
            this.textBuffer[this.cursor++] = (char)c;
        }
        if (c != -1) {
            this.reader.unread(c);
        }
        return c;
    }

    private void readUntil(char delimiter) throws IOException {
        int c;
        boolean escaped = false;
        while ((c = this.reader.read()) != -1 && (c != delimiter || escaped)) {
            this.textBuffer[this.cursor++] = (char)c;
            escaped = c == 92;
        }
        if (c != -1) {
            this.reader.unread(c);
        }
    }

    private static int peek(PushbackReader reader) throws IOException {
        int c = reader.read();
        reader.unread(c);
        return c;
    }

    private void assertChar(char expectedChar) throws ParseException, IOException {
        int c = this.reader.read();
        if (c != expectedChar) {
            throw new ParseException("Expected: '" + expectedChar + "', found: '" + (char)c + "'", 0);
        }
        this.textBuffer[this.cursor++] = expectedChar;
    }

    private void expectChar(char expectedChar) throws ParseException, IOException {
        int c = this.reader.read();
        if (c != expectedChar) {
            String message = "Expected: '" + expectedChar + "', found: '" + (char)c + "'";
            logger.error((Object)message, (Throwable)new ParseException(message, -1));
            this.reader.unread(c);
        }
        this.textBuffer[this.cursor++] = expectedChar;
    }

    private void assertChar(char expectedChar, boolean skipSpace) throws ParseException, IOException {
        int c;
        do {
            if ((c = this.reader.read()) == -1) continue;
            this.textBuffer[this.cursor++] = (char)c;
        } while (c != -1 && skipSpace && Character.isWhitespace(c));
        if (c != expectedChar) {
            throw new ParseException("Expected: '" + expectedChar + "', found: '" + (char)c + "'", 0);
        }
    }

    private void skipWhitespace() throws IOException {
        int c;
        while ((c = this.reader.read()) != -1 && Character.isWhitespace(c)) {
            this.textBuffer[this.cursor++] = (char)c;
        }
        if (c != -1) {
            this.reader.unread(c);
        }
    }
}

