/*
 * Decompiled with CFR 0.152.
 */
package org.databene.html;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Map;
import java.util.Stack;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.html.DefaultHTMLTokenizer;
import org.databene.html.HTMLEntity;
import org.databene.html.HTMLTokenizer;
import org.databene.html.HTMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTML2XML {
    public static String convert(String html) throws ParseException {
        StringReader reader = new StringReader(html);
        StringWriter writer = new StringWriter();
        try {
            HTML2XML.convert(reader, writer);
            String string = writer.getBuffer().toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public static void convert(Reader reader, Writer writer) throws IOException, ParseException {
        int token;
        HTML2XML.writeHeader(writer);
        ConversionContext context = new ConversionContext(reader, writer);
        block10: while ((token = context.tokenizer.nextToken()) != -1) {
            switch (token) {
                case 2: {
                    String lastTagName;
                    if ("script".equalsIgnoreCase(context.tokenizer.name())) continue block10;
                    if (!context.rootCreated && !"html".equals(context.tokenizer.name())) {
                        HTML2XML.ensureRootElement(context);
                    } else if (context.path.size() > 0 && HTMLUtil.isEmptyTag(lastTagName = context.path.peek()) && !context.tokenizer.name().equals(lastTagName)) {
                        context.writer.write("</" + lastTagName + '>');
                        context.path.pop();
                    }
                    HTML2XML.writeStartTag(context.writer, context.tokenizer);
                    context.rootCreated = true;
                    context.path.push(context.tokenizer.name());
                    continue block10;
                }
                case 4: {
                    HTML2XML.writeEmptyTag(context.writer, context.tokenizer);
                    continue block10;
                }
                case 3: {
                    if ("script".equalsIgnoreCase(context.tokenizer.name())) continue block10;
                    boolean done = false;
                    if (HTML2XML.contains(context.path, context.tokenizer.name())) {
                        do {
                            String pathTagName = context.path.pop();
                            context.writer.write("</" + pathTagName + '>');
                            if (!pathTagName.equals(context.tokenizer.name())) continue;
                            done = true;
                        } while (!done);
                    }
                    if (!"html".equalsIgnoreCase(context.tokenizer.name())) continue block10;
                    return;
                }
                case 1: {
                    HTML2XML.ensureRootElement(context);
                    HTML2XML.writeText(context.writer, context.tokenizer.text());
                    continue block10;
                }
                case 5: {
                    HTML2XML.ensureRootElement(context);
                    HTML2XML.writeText(context.writer, context.tokenizer.text());
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
                case 6: {
                    HTML2XML.writeText(context.writer, context.tokenizer.text());
                    continue block10;
                }
                case 7: {
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("Unsupported token type: " + token);
        }
        while (context.path.size() > 0) {
            String tagName = context.path.pop();
            context.writer.write("</" + tagName + '>');
        }
    }

    private static void ensureRootElement(ConversionContext context) throws IOException {
        if (!context.rootCreated && !"html".equals(context.tokenizer.name())) {
            HTML2XML.writeStartTag(context.writer, "html");
            context.path.push("html");
            context.rootCreated = true;
        }
    }

    private static boolean contains(Stack<String> path, String name) {
        for (String tagName : path) {
            if (!tagName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static void writeHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\"?>" + SystemInfo.getLineSeparator());
    }

    private static void writeEmptyTag(Writer writer, HTMLTokenizer tokenizer) throws IOException {
        writer.write('<' + tokenizer.name());
        HTML2XML.writeAttributes(writer, tokenizer);
        writer.write("/>");
    }

    private static void writeStartTag(Writer writer, HTMLTokenizer tokenizer) throws IOException {
        writer.write('<' + tokenizer.name());
        HTML2XML.writeAttributes(writer, tokenizer);
        writer.write(62);
    }

    private static void writeStartTag(Writer writer, String name) throws IOException {
        writer.write('<' + name + '>');
    }

    private static void writeAttributes(Writer writer, HTMLTokenizer tokenizer) throws IOException {
        for (Map.Entry<String, String> entry : tokenizer.attributes().entrySet()) {
            String value = entry.getValue();
            int quote = 34;
            if (value == null) {
                value = "";
            } else if (value.contains("\"")) {
                quote = 39;
            }
            writer.write(32);
            writer.write(entry.getKey());
            writer.write(61);
            writer.write(quote);
            HTML2XML.writeText(writer, value);
            writer.write(quote);
        }
    }

    private static void writeText(Writer writer, String s) throws IOException {
        int i;
        while ((i = s.indexOf(38)) >= 0) {
            HTMLEntity entity = HTMLEntity.getEntity(s, i);
            if (entity != null) {
                writer.write(s.substring(0, i + 1));
                writer.write("#" + entity.xmlCode + ";");
                s = s.substring(i + entity.htmlCode.length() + 2);
                continue;
            }
            writer.write(s.substring(0, i));
            writer.write("&amp;");
            s = s.substring(i + 1);
        }
        writer.write(s);
    }

    private static class ConversionContext {
        Writer writer;
        HTMLTokenizer tokenizer;
        Stack<String> path;
        boolean rootCreated;

        ConversionContext(Reader reader, Writer writer) {
            this.tokenizer = new DefaultHTMLTokenizer(reader);
            this.path = new Stack();
            this.rootCreated = false;
            this.writer = writer;
        }
    }
}

