/*
 * Decompiled with CFR 0.152.
 */
package org.databene.regex;

import java.text.ParseException;
import java.util.Map;
import org.databene.commons.CollectionUtil;
import org.databene.commons.StringCharacterIterator;
import org.databene.regex.RegexTokenType;

public class RegexTokenizer {
    private static final String QUANTIFIERS = "?*+";
    private static final Map<Character, State> escapedTokens = CollectionUtil.buildMap((Object[])new Object[]{Character.valueOf('d'), new State(RegexTokenType.PREDEFINED_CLASS, 'd'), Character.valueOf('D'), new State(RegexTokenType.PREDEFINED_CLASS, 'D'), Character.valueOf('W'), new State(RegexTokenType.PREDEFINED_CLASS, 'W'), Character.valueOf('w'), new State(RegexTokenType.PREDEFINED_CLASS, 'w'), Character.valueOf('s'), new State(RegexTokenType.PREDEFINED_CLASS, 's'), Character.valueOf('S'), new State(RegexTokenType.PREDEFINED_CLASS, 'S'), Character.valueOf('+'), new State(RegexTokenType.CHARACTER, '+'), Character.valueOf('-'), new State(RegexTokenType.CHARACTER, '-'), Character.valueOf('\\'), new State(RegexTokenType.CHARACTER, '\\'), Character.valueOf('.'), new State(RegexTokenType.CHARACTER, '.'), Character.valueOf('t'), new State(RegexTokenType.CHARACTER, '\t'), Character.valueOf('n'), new State(RegexTokenType.CHARACTER, '\n'), Character.valueOf('r'), new State(RegexTokenType.CHARACTER, '\r'), Character.valueOf('f'), new State(RegexTokenType.CHARACTER, '\f'), Character.valueOf('a'), new State(RegexTokenType.CHARACTER, '\u0007'), Character.valueOf('e'), new State(RegexTokenType.CHARACTER, '\u001b')});
    private final StringCharacterIterator iterator;
    public char cval;
    public RegexTokenType ttype;
    boolean pushedBack;

    public RegexTokenizer(String regex) {
        this.iterator = new StringCharacterIterator(regex);
        this.pushedBack = false;
    }

    public RegexTokenType next() throws ParseException {
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.ttype;
        }
        if (!this.iterator.hasNext()) {
            return RegexTokenType.END;
        }
        char c = this.iterator.next();
        if (c == '.') {
            this.setState(RegexTokenType.PREDEFINED_CLASS, '.');
        } else if (c == '\\') {
            char c2 = this.iterator.next();
            State state = escapedTokens.get(Character.valueOf(c2));
            if (state != null) {
                this.setState(state.ttype, state.cval);
            } else {
                switch (c2) {
                    case 'x': {
                        this.parseHexCharacter(1);
                        break;
                    }
                    case 'u': {
                        this.parseHexCharacter(2);
                        break;
                    }
                    case '0': {
                        this.parseOctalCharacters();
                        break;
                    }
                    case 'c': {
                        this.setState(RegexTokenType.CHARACTER, (char)(Character.toUpperCase(this.iterator.next()) - 65));
                        break;
                    }
                    default: {
                        throw new ParseException("unknown token: \\" + c2, this.iterator.index());
                    }
                }
            }
        } else if (QUANTIFIERS.indexOf(c) >= 0) {
            this.setState(RegexTokenType.QUANTIFIER, c);
        } else if (Character.isDigit(c)) {
            this.setState(RegexTokenType.DIGIT, c);
        } else {
            switch (c) {
                case '(': {
                    this.setState(RegexTokenType.GROUP_START, c);
                    break;
                }
                case ')': {
                    this.setState(RegexTokenType.GROUP_END, c);
                    break;
                }
                case '|': {
                    this.setState(RegexTokenType.ALTERNATIVE_SEPARATOR, c);
                    break;
                }
                case '[': {
                    this.setState(RegexTokenType.SET_START, c);
                    break;
                }
                case ']': {
                    this.setState(RegexTokenType.SET_END, c);
                    break;
                }
                case '{': {
                    this.setState(RegexTokenType.QUANTIFIER_START, c);
                    break;
                }
                case '}': {
                    this.setState(RegexTokenType.QUANTIFIER_END, c);
                    break;
                }
                case '^': {
                    this.setState(RegexTokenType.NEGATION, c);
                    break;
                }
                default: {
                    this.setState(RegexTokenType.CHARACTER, c);
                }
            }
        }
        return this.ttype;
    }

    private void parseHexCharacter(int bytes) {
        int result = 0;
        for (int i = 0; i < bytes; ++i) {
            result = result * 16 + this.iterator.next() - 48;
        }
        this.setState(RegexTokenType.CHARACTER, (char)result);
    }

    private void parseOctalCharacters() {
        char c;
        int result = 0;
        for (int i = 0; i < 3 && this.iterator.hasNext() && (c = this.iterator.next()) >= '0' && c <= '7'; ++i) {
            result = result * 8 + c - 48;
        }
        this.setState(RegexTokenType.CHARACTER, (char)result);
    }

    private void setState(RegexTokenType ttype, char cval) {
        this.ttype = ttype;
        this.cval = cval;
    }

    public boolean hasNext() {
        return this.pushedBack || this.iterator.hasNext();
    }

    public void pushBack() {
        if (this.pushedBack) {
            throw new IllegalStateException("Cannot pushBack() twice");
        }
        this.pushedBack = true;
    }

    public int index() {
        return this.iterator.index();
    }

    public void assertNext(RegexTokenType expectedType) throws ParseException {
        RegexTokenType type = this.next();
        if (type != expectedType) {
            throw new ParseException("Expected " + (Object)((Object)expectedType) + " found: " + (Object)((Object)type), this.iterator.index());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.iterator + ']';
    }

    private static final class State {
        RegexTokenType ttype;
        char cval;

        public State(RegexTokenType ttype, char cval) {
            this.ttype = ttype;
            this.cval = cval;
        }
    }
}

