/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.FileUtil;
import org.databene.commons.IOUtil;
import org.databene.commons.StringCharacterIterator;
import org.databene.script.ConstantScript;
import org.databene.script.Script;
import org.databene.script.ScriptFactory;
import org.databene.script.jsr227.Jsr223ScriptFactory;

public class ScriptUtil {
    private static final Log configLogger = LogFactory.getLog((String)"org.databene.CONFIG");
    private static String defaultScriptEngine = "ftl";
    private static Map<String, ScriptFactory> factories;
    private static final String SETUP_FILE_NAME = "org/databene/script/script.properties";
    private static Map<String, Script> scriptsByName;

    public static Object execute(Script script, Context context) {
        return script.evaluate(context);
    }

    public static Object render(String text, Context context) {
        if (text.startsWith("{{") && text.endsWith("}}")) {
            return text.substring(1, text.length() - 1);
        }
        if (text.startsWith("{") && text.endsWith("}")) {
            Script script = ScriptUtil.parseUnspecificText(text);
            return ScriptUtil.execute(script, context);
        }
        return text;
    }

    public static Script readFile(String uri) throws IOException {
        Script script = scriptsByName.get(uri);
        if (script == null) {
            String engineId = FileUtil.suffix((String)uri);
            ScriptFactory factory = ScriptUtil.getFactory(engineId);
            script = factory.readFile(uri);
            scriptsByName.put(uri, script);
        }
        return script;
    }

    public static Script parseSpecificText(String text, String engineId) {
        if (engineId == null) {
            throw new IllegalArgumentException("engineId is null");
        }
        ScriptFactory factory = ScriptUtil.getFactory(engineId);
        if (factory != null) {
            return factory.parseText(text);
        }
        return new ConstantScript(text);
    }

    public static Script parseUnspecificText(String text) {
        if (text.startsWith("{") && text.endsWith("}")) {
            text = text.substring(1, text.length() - 1);
            Script script = null;
            StringCharacterIterator iterator = new StringCharacterIterator(text);
            String engineId = iterator.parseLetters();
            iterator.skipWhitespace();
            if (iterator.next() == ':') {
                if (ScriptUtil.getFactory(engineId) != null) {
                    String scriptText = iterator.remainingText();
                    script = ScriptUtil.parseSpecificText(scriptText, engineId);
                } else {
                    script = ScriptUtil.parseSpecificText(text, ScriptUtil.getDefaultScriptEngine());
                }
            } else {
                script = ScriptUtil.parseSpecificText(text, ScriptUtil.getDefaultScriptEngine());
            }
            return script;
        }
        return new ConstantScript(text);
    }

    private static ScriptFactory getFactory(String engineId) {
        return factories.get(engineId);
    }

    private static void parseConfigFile() {
        String className = null;
        try {
            ScriptFactory factory;
            factories = new HashMap<String, ScriptFactory>();
            try {
                ScriptEngineManager mgr = new ScriptEngineManager();
                for (ScriptEngineFactory scriptEngineFactory : mgr.getEngineFactories()) {
                    factory = new Jsr223ScriptFactory(scriptEngineFactory.getScriptEngine());
                    List<String> names = scriptEngineFactory.getNames();
                    for (String name : names) {
                        factories.put(name, factory);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                configLogger.error((Object)"Java 6/JSR 223 script engines not available, deactivating script engine support.");
            }
            configLogger.debug((Object)"Initializing Script mapping from file org/databene/script/script.properties");
            Map properties = IOUtil.readProperties((String)SETUP_FILE_NAME);
            for (Map.Entry entry : properties.entrySet()) {
                className = ((String)entry.getValue()).toString();
                factory = (ScriptFactory)BeanUtil.newInstance((String)className);
                factories.put(((String)entry.getKey()).toString(), factory);
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationError("Setup file not found: org/databene/script/script.properties", (Throwable)e);
        }
        catch (IOException e) {
            throw new ConfigurationError("I/O Error while reading file: org/databene/script/script.properties", (Throwable)e);
        }
    }

    public static String getDefaultScriptEngine() {
        return defaultScriptEngine;
    }

    public static void setDefaultScriptEngine(String defaultScriptEngine) {
        ScriptUtil.defaultScriptEngine = defaultScriptEngine;
    }

    static {
        ScriptUtil.parseConfigFile();
        scriptsByName = new WeakHashMap<String, Script>();
    }
}

