/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.quickscript;

import java.util.ArrayList;
import org.databene.commons.Accessor;
import org.databene.commons.CollectionUtil;
import org.databene.commons.StringCharacterIterator;
import org.databene.commons.accessor.ConstantAccessor;
import org.databene.commons.accessor.FallbackAccessor;
import org.databene.commons.accessor.FeatureAccessor;
import org.databene.commons.accessor.GraphAccessor;

class QuickScriptTokenizer {
    QuickScriptTokenizer() {
    }

    public static Accessor[] tokenize(String text) {
        ArrayList<Accessor> tokens = new ArrayList<Accessor>();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        while (iterator.hasNext()) {
            tokens.add(QuickScriptTokenizer.nextToken(iterator));
        }
        return (Accessor[])CollectionUtil.toArray(tokens, Accessor.class);
    }

    private static Accessor nextToken(StringCharacterIterator iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        if (iterator.next() == '$') {
            if (iterator.hasNext() && iterator.next() == '{') {
                return QuickScriptTokenizer.parseVariable(iterator);
            }
            iterator.pushBack();
            iterator.pushBack();
            return QuickScriptTokenizer.parseText(iterator);
        }
        iterator.pushBack();
        return QuickScriptTokenizer.parseText(iterator);
    }

    private static Accessor parseText(StringCharacterIterator iterator) {
        StringBuilder buffer = new StringBuilder();
        char c = ' ';
        while (iterator.hasNext()) {
            char c2 = iterator.next();
            c = c2;
            if (c2 == '$') break;
            buffer.append(c);
        }
        if (c == '$') {
            iterator.pushBack();
        }
        return new ConstantAccessor((Object)buffer.toString());
    }

    private static Accessor parseVariable(StringCharacterIterator iterator) {
        StringBuilder buffer = new StringBuilder();
        char c = ' ';
        while (iterator.hasNext()) {
            char c2 = iterator.next();
            c = c2;
            if (c2 == '}') break;
            buffer.append(c);
        }
        String expression = buffer.toString().trim();
        if (c == '}') {
            if (expression.contains(".")) {
                return new FallbackAccessor(new Accessor[]{new FeatureAccessor(expression), new GraphAccessor(expression)});
            }
            return new FeatureAccessor(expression);
        }
        return new ConstantAccessor((Object)("${" + expression));
    }
}

