/*
 * Decompiled with CFR 0.152.
 */
package org.databene.webdecs.demo;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.databene.commons.Filter;
import org.databene.commons.iterator.FilteringIterator;
import org.databene.document.csv.ArrayCSVWriter;
import org.databene.document.csv.CSVLineIterator;

public class CSVFilterDemo {
    private static final String FILE_NAME = "test.dat";

    public static void main(String[] args) throws IOException {
        FileReader reader = new FileReader(FILE_NAME);
        CSVLineIterator src = new CSVLineIterator(reader, '|');
        RowFilter filter = new RowFilter();
        FilteringIterator iterator = new FilteringIterator((Iterator)((Object)src), (Filter)filter);
        BufferedWriter out = new BufferedWriter(new FileWriter("matches.csv"));
        ArrayCSVWriter csvWriter = new ArrayCSVWriter(out, '|');
        int matchCount = 0;
        System.out.println("Running...");
        long startMillis = System.currentTimeMillis();
        while (iterator.hasNext()) {
            String[] cells = (String[])iterator.next();
            csvWriter.writeElement(cells);
            ++matchCount;
        }
        ((Writer)out).close();
        ((Reader)reader).close();
        long elapsedTime = System.currentTimeMillis() - startMillis;
        System.out.println("Processed file test.dat with " + src.lineCount() + " entries " + "within " + elapsedTime + "ms (" + (long)src.lineCount() * 1000L / elapsedTime + " entries per second)");
        System.out.println("Found " + matchCount + " matches");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RowFilter
    implements Filter<String[]> {
        private RowFilter() {
        }

        public boolean accept(String[] candidate) {
            return candidate.length > 2 && "3023293310905".equals(candidate[1]);
        }
    }
}

