/*
 * Decompiled with CFR 0.152.
 */
package org.databene.webdecs.demo;

import java.io.IOException;
import java.text.ParseException;
import javax.xml.transform.TransformerException;
import org.databene.commons.ConversionException;
import org.databene.commons.IOUtil;
import org.databene.html.HTML2XML;
import org.databene.text.SplitStringConverter;
import org.databene.xslt.XSLTTransformer;

public class HTMLTextExtractorDemo {
    private static final String XSLT_FILENAME = "org/databene/webdecs/demo/HTMLTextExtractorDemo.xsl";

    public static void main(String[] args) throws IOException, ParseException, TransformerException, ConversionException {
        String html = IOUtil.getContentOfURI((String)"http://www.yahoo.com");
        String xml = HTML2XML.convert(html);
        String xslt = IOUtil.getContentOfURI((String)XSLT_FILENAME);
        String xsltResult = XSLTTransformer.transform(xml, xslt);
        System.out.println("XSLT result: " + xsltResult);
        SplitStringConverter converter = new SplitStringConverter('|');
        String[] headlines = (String[])converter.convert(xsltResult);
        System.out.println("Yahoo headlines :");
        System.out.println("- - - - - - - - -");
        for (int i = 0; i < headlines.length; ++i) {
            System.out.println(i + 1 + ". " + headlines[i]);
        }
    }
}

