/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Parameter;
import javax.persistence.ParameterMode;
import javax.persistence.QueryTimeoutException;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TemporalType;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.api.jpa.JPAQuery;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.StoredProcQueryParameterMode;
import org.datanucleus.store.query.AbstractStoredProcedureQuery;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;

public class JPAStoredProcedureQuery
extends JPAQuery
implements StoredProcedureQuery {
    boolean executeProcessed = false;

    public JPAStoredProcedureQuery(EntityManager em, Query query) {
        super((JPAEntityManager)em, query, "STOREDPROCEDURE");
    }

    private AbstractStoredProcedureQuery getStoredProcQuery() {
        return (AbstractStoredProcedureQuery)this.query;
    }

    public JPAStoredProcedureQuery setParameter(Parameter param, Object value) {
        super.setParameter(param, value);
        return this;
    }

    @Override
    public JPAStoredProcedureQuery setParameter(Parameter param, Calendar cal, TemporalType type) {
        super.setParameter(param, cal, type);
        return this;
    }

    public JPAStoredProcedureQuery setParameter(Parameter param, Date date, TemporalType type) {
        super.setParameter((Parameter<Date>)param, date, type);
        return this;
    }

    public JPAStoredProcedureQuery setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    public JPAStoredProcedureQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    public JPAStoredProcedureQuery setParameter(String name, Date date, TemporalType type) {
        super.setParameter(name, date, type);
        return this;
    }

    public JPAStoredProcedureQuery setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    public JPAStoredProcedureQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    public JPAStoredProcedureQuery setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        StoredProcQueryParameterMode paramMode = null;
        if (mode == ParameterMode.IN) {
            paramMode = StoredProcQueryParameterMode.IN;
        } else if (mode == ParameterMode.OUT) {
            paramMode = StoredProcQueryParameterMode.OUT;
        } else if (mode == ParameterMode.INOUT) {
            paramMode = StoredProcQueryParameterMode.INOUT;
        } else if (mode == ParameterMode.REF_CURSOR) {
            paramMode = StoredProcQueryParameterMode.REF_CURSOR;
        }
        this.getStoredProcQuery().registerParameter(position, type, paramMode);
        return this;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        StoredProcQueryParameterMode paramMode = null;
        if (mode == ParameterMode.IN) {
            paramMode = StoredProcQueryParameterMode.IN;
        } else if (mode == ParameterMode.OUT) {
            paramMode = StoredProcQueryParameterMode.OUT;
        } else if (mode == ParameterMode.INOUT) {
            paramMode = StoredProcQueryParameterMode.INOUT;
        } else if (mode == ParameterMode.REF_CURSOR) {
            paramMode = StoredProcQueryParameterMode.REF_CURSOR;
        }
        this.getStoredProcQuery().registerParameter(parameterName, type, paramMode);
        return this;
    }

    public Object getOutputParameterValue(int position) {
        return this.getStoredProcQuery().getOutputParameterValue(position);
    }

    public Object getOutputParameterValue(String parameterName) {
        return this.getStoredProcQuery().getOutputParameterValue(parameterName);
    }

    public boolean execute() {
        Object hasResultSet = this.query.execute();
        this.executeProcessed = true;
        return (Boolean)hasResultSet;
    }

    public boolean hasMoreResults() {
        if (this.executeProcessed) {
            return this.getStoredProcQuery().hasMoreResults();
        }
        return false;
    }

    public int getUpdateCount() {
        if (this.executeProcessed) {
            return this.getStoredProcQuery().getUpdateCount();
        }
        return -1;
    }

    @Override
    public int executeUpdate() {
        try {
            Boolean hasResultSet;
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            if ((hasResultSet = (Boolean)this.query.execute()).booleanValue()) {
                throw new IllegalStateException("Stored procedure returned a result set but method requires an update count");
            }
            return this.getStoredProcQuery().getUpdateCount();
        }
        catch (NoQueryResultsException nqre) {
            return 0;
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    @Override
    public List getResultList() {
        if (this.executeProcessed) {
            return (List)this.getStoredProcQuery().getNextResults();
        }
        try {
            Boolean hasResultSet;
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            if (!(hasResultSet = (Boolean)this.query.execute()).booleanValue()) {
                throw new IllegalStateException("Stored proc should have returned result set but didnt");
            }
            return (List)this.getStoredProcQuery().getNextResults();
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public Object getSingleResult() {
        if (this.executeProcessed) {
            this.query.setUnique(true);
            return this.getStoredProcQuery().getNextResults();
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            this.query.setUnique(true);
            Boolean hasResultSet = (Boolean)this.query.execute();
            if (!hasResultSet.booleanValue()) {
                throw new IllegalStateException("Stored proc should have returned result set but didnt");
            }
            return this.getStoredProcQuery().getNextResults();
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public JPAStoredProcedureQuery setFlushMode(FlushModeType mode) {
        return (JPAStoredProcedureQuery)super.setFlushMode(mode);
    }

    public JPAStoredProcedureQuery setHint(String hintName, Object value) {
        return (JPAStoredProcedureQuery)super.setHint(hintName, value);
    }
}

