/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.annotations;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MultitenancyMetaData;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.ClassAnnotationHandler;
import org.datanucleus.util.StringUtils;

public class MultiTenantHandler
implements ClassAnnotationHandler {
    public void processClassAnnotation(AnnotationObject annotation, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        MultitenancyMetaData mtmd = cmd.newMultitenancyMetaData();
        Map annotationValues = annotation.getNameValueMap();
        String columnName = (String)annotationValues.get("column");
        Integer colLength = (Integer)annotationValues.get("columnLength");
        String jdbcType = (String)annotationValues.get("jdbcType");
        if (colLength != null || !StringUtils.isWhitespace((String)jdbcType)) {
            ColumnMetaData colmd = mtmd.newColumnMetaData();
            if (!StringUtils.isWhitespace((String)columnName)) {
                mtmd.setColumnName(columnName);
                colmd.setName(columnName);
            }
            if (colLength != null) {
                colmd.setLength(colLength);
            }
            if (!StringUtils.isWhitespace((String)jdbcType)) {
                colmd.setJdbcType(jdbcType);
            }
        } else if (!StringUtils.isWhitespace((String)columnName)) {
            mtmd.setColumnName(columnName);
        }
    }
}

