/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo.query;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.query.BooleanExpression;
import javax.jdo.query.ByteExpression;
import javax.jdo.query.CharacterExpression;
import javax.jdo.query.CollectionExpression;
import javax.jdo.query.DateExpression;
import javax.jdo.query.DateTimeExpression;
import javax.jdo.query.EnumExpression;
import javax.jdo.query.ListExpression;
import javax.jdo.query.LocalDateExpression;
import javax.jdo.query.LocalDateTimeExpression;
import javax.jdo.query.LocalTimeExpression;
import javax.jdo.query.MapExpression;
import javax.jdo.query.NumericExpression;
import javax.jdo.query.ObjectExpression;
import javax.jdo.query.OptionalExpression;
import javax.jdo.query.PersistableExpression;
import javax.jdo.query.StringExpression;
import javax.jdo.query.TimeExpression;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.datanucleus.jdo.query.AnnotationProcessorUtils;

@SupportedAnnotationTypes(value={"javax.jdo.annotations.PersistenceCapable"})
public class JDOQueryProcessor
extends AbstractProcessor {
    public static final String OPTION_MODE = "queryMode";
    private static final int MODE_FIELD = 1;
    private static final int MODE_PROPERTY = 2;
    private static final String CODE_INDENT = "    ";
    public int queryMode = 1;
    public int fieldDepth = 5;
    boolean allowGeospatialExtensions = false;

    @Override
    public synchronized void init(ProcessingEnvironment pe) {
        super.init(pe);
        pe.getMessager().printMessage(Diagnostic.Kind.NOTE, "DataNucleus JDO AnnotationProcessor for generating JDOQLTypedQuery Q classes");
        String queryMode = pe.getOptions().get(OPTION_MODE);
        if (queryMode != null && queryMode.equalsIgnoreCase("FIELD")) {
            this.queryMode = 1;
        }
        try {
            Class.forName("javax.jdo.query.geospatial.GeometryExpression");
            this.allowGeospatialExtensions = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> elements = roundEnv.getRootElements();
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            this.processClass((TypeElement)element);
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClass(TypeElement el) {
        if (el == null || !this.isPersistableType(el)) {
            return;
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        String classNameFull = elementUtils.getBinaryName(el).toString();
        String pkgName = classNameFull.substring(0, classNameFull.lastIndexOf(46));
        String classNameSimple = classNameFull.substring(classNameFull.lastIndexOf(46) + 1);
        String qclassNameSimple = JDOQueryProcessor.getQueryClassNameForClassName(classNameSimple);
        String qclassNameFull = pkgName + "." + qclassNameSimple;
        System.out.println("DataNucleus : JDOQLTypedQuery Q class generation : " + classNameFull + " -> " + qclassNameFull);
        HashMap<String, TypeMirror> genericLookups = null;
        List<? extends TypeParameterElement> elTypeParams = el.getTypeParameters();
        for (TypeParameterElement typeParameterElement : elTypeParams) {
            List<? extends TypeMirror> elTypeBounds = typeParameterElement.getBounds();
            if (elTypeBounds == null || elTypeBounds.isEmpty()) continue;
            genericLookups = new HashMap<String, TypeMirror>();
            genericLookups.put(typeParameterElement.toString(), elTypeBounds.get(0));
        }
        try {
            JavaFileObject javaFile = this.processingEnv.getFiler().createSourceFile(qclassNameFull, new Element[0]);
            try (Writer writer = javaFile.openWriter();){
                writer.append("package " + pkgName + ";\n");
                writer.append("\n");
                writer.append("import javax.annotation.processing.Generated;\n");
                writer.append("import javax.jdo.query.*;\n");
                writer.append("import org.datanucleus.api.jdo.query.*;\n");
                List<? extends Element> encElems = el.getEnclosedElements();
                if (encElems != null) {
                    for (Element element : encElems) {
                        TypeElement encEl;
                        if (!(element instanceof TypeElement) || !this.isPersistableType(encEl = (TypeElement)element)) continue;
                        String innerclassNameFull = elementUtils.getBinaryName(encEl).toString();
                        String string = innerclassNameFull.substring(innerclassNameFull.lastIndexOf(46) + 1);
                        String innerclassNameSimpleShort = string.substring(string.indexOf("$") + 1);
                        writer.append("import " + classNameFull + "." + innerclassNameSimpleShort + ";\n");
                    }
                }
                writer.append("\n");
                writer.append("@Generated(value=\"" + this.getClass().getName() + "\")\n");
                writer.append("public class " + qclassNameSimple);
                TypeElement superEl = this.getPersistentSupertype(el);
                if (superEl != null) {
                    String string = elementUtils.getBinaryName(superEl).toString();
                    writer.append(" extends ").append(string.substring(0, string.lastIndexOf(46) + 1));
                    writer.append(JDOQueryProcessor.getQueryClassNameForClassName(string.substring(string.lastIndexOf(46) + 1)));
                } else {
                    writer.append(" extends ").append("PersistableExpressionImpl").append("<" + classNameSimple + ">");
                    writer.append(" implements ").append(PersistableExpression.class.getSimpleName() + "<" + classNameSimple + ">");
                }
                writer.append("\n");
                writer.append("{\n");
                String string = CODE_INDENT;
                this.addStaticMethodAccessors(writer, string, qclassNameSimple, classNameSimple);
                writer.append("\n");
                List<? extends Element> members = JDOQueryProcessor.getPersistentMembers(el);
                if (members != null) {
                    for (Element element : members) {
                        if (element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)element))) continue;
                        TypeMirror type = AnnotationProcessorUtils.getDeclaredType(element);
                        if (type instanceof TypeVariable && genericLookups != null && genericLookups.containsKey(type.toString())) {
                            type = (TypeMirror)genericLookups.get(type.toString());
                        }
                        String memberName = AnnotationProcessorUtils.getMemberName(element);
                        String intfName = this.getExpressionInterfaceNameForType(type);
                        if (intfName.startsWith(classNameFull + ".")) {
                            intfName = intfName.substring(classNameFull.length() + 1);
                        }
                        if (this.queryMode == 1) {
                            writer.append(string).append("public final ").append(intfName);
                            writer.append(" ").append(memberName).append(";\n");
                            continue;
                        }
                        writer.append(string).append("private ").append(intfName);
                        writer.append(" ").append(memberName).append(";\n");
                    }
                }
                writer.append("\n");
                this.addConstructorWithPersistableExpression(writer, string, qclassNameSimple, superEl, members, classNameFull, genericLookups);
                writer.append("\n");
                this.addConstructorWithType(writer, string, qclassNameSimple, members, classNameFull, genericLookups);
                if (this.queryMode == 2 && members != null) {
                    for (Element element : members) {
                        if (element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)element))) continue;
                        writer.append("\n");
                        this.addPropertyAccessorMethod(writer, string, element, classNameFull, genericLookups);
                    }
                }
                if (encElems != null) {
                    for (Element element : encElems) {
                        if (!(element instanceof TypeElement)) continue;
                        String indentInner = "        ";
                        TypeElement encEl = (TypeElement)element;
                        if (!this.isPersistableType(encEl)) continue;
                        writer.append("\n");
                        System.out.println("Persistable (static) inner class " + elementUtils.getBinaryName(encEl).toString() + " really should be in own file. Trying to generate Q class inlined!");
                        String innerclassNameFull = elementUtils.getBinaryName(encEl).toString();
                        String innerclassNameSimple = innerclassNameFull.substring(innerclassNameFull.lastIndexOf(46) + 1);
                        String innerclassNameSimpleShort = innerclassNameSimple.substring(innerclassNameSimple.indexOf("$") + 1);
                        String qinnerclassNameSimpleShort = JDOQueryProcessor.getQueryClassNameForClassName(innerclassNameSimpleShort);
                        String qinnerclassNameFull = pkgName + "." + qclassNameSimple + "$" + qinnerclassNameSimpleShort;
                        System.out.println("DataNucleus : JDOQLTypedQuery Q class generation : " + innerclassNameFull + " -> " + qinnerclassNameFull);
                        writer.append(string).append("public static class " + qinnerclassNameSimpleShort);
                        TypeElement innerSuperEl = this.getPersistentSupertype(encEl);
                        if (innerSuperEl != null) {
                            String superClassName = elementUtils.getBinaryName(innerSuperEl).toString();
                            writer.append(" extends ").append(superClassName.substring(0, superClassName.lastIndexOf(46) + 1));
                            writer.append(JDOQueryProcessor.getQueryClassNameForClassName(superClassName.substring(superClassName.lastIndexOf(46) + 1)));
                        } else {
                            writer.append(" extends ").append("PersistableExpressionImpl").append("<" + innerclassNameSimpleShort + ">");
                            writer.append(" implements ").append(PersistableExpression.class.getSimpleName() + "<" + innerclassNameSimpleShort + ">");
                        }
                        writer.append("\n");
                        writer.append(string).append("{\n");
                        this.addStaticMethodAccessors(writer, indentInner, qinnerclassNameSimpleShort, innerclassNameSimpleShort);
                        writer.append("\n");
                        List<? extends Element> innerMembers = JDOQueryProcessor.getPersistentMembers(encEl);
                        if (members != null) {
                            for (Element element2 : innerMembers) {
                                if (element2.getKind() != ElementKind.FIELD && (element2.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)element2))) continue;
                                TypeMirror type = AnnotationProcessorUtils.getDeclaredType(element2);
                                if (type instanceof TypeVariable && genericLookups != null && genericLookups.containsKey(type.toString())) {
                                    type = (TypeMirror)genericLookups.get(type.toString());
                                }
                                String memberName = AnnotationProcessorUtils.getMemberName(element2);
                                String intfName = this.getExpressionInterfaceNameForType(type);
                                if (this.queryMode == 1) {
                                    writer.append(indentInner).append("public final ").append(intfName).append(" ").append(memberName).append(";\n");
                                    continue;
                                }
                                writer.append(indentInner).append("private ").append(intfName).append(" ").append(memberName).append(";\n");
                            }
                        }
                        writer.append("\n");
                        this.addConstructorWithPersistableExpression(writer, indentInner, qinnerclassNameSimpleShort, innerSuperEl, innerMembers, classNameFull, genericLookups);
                        writer.append("\n");
                        this.addConstructorWithType(writer, indentInner, qinnerclassNameSimpleShort, innerMembers, classNameFull, genericLookups);
                        if (this.queryMode == 2 && members != null) {
                            for (Element element3 : members) {
                                if (element3.getKind() != ElementKind.FIELD && (element3.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)element3))) continue;
                                writer.append("\n");
                                this.addPropertyAccessorMethod(writer, indentInner, element3, classNameFull, genericLookups);
                            }
                        }
                        writer.append(string).append("}\n");
                    }
                }
                writer.append("}\n");
                writer.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void addStaticMethodAccessors(Writer w, String indent, String qclassNameSimple, String classNameSimple) throws IOException {
        w.append(indent).append("public static final ").append(qclassNameSimple).append(" jdoCandidate").append(" = candidate(\"this\");\n");
        w.append("\n");
        w.append(indent).append("public static " + qclassNameSimple + " candidate(String name)\n");
        w.append(indent).append("{\n");
        w.append(indent).append(CODE_INDENT).append("return new ").append(qclassNameSimple).append("(null, name, " + this.fieldDepth + ");\n");
        w.append(indent).append("}\n");
        w.append("\n");
        w.append(indent).append("public static " + qclassNameSimple + " candidate()\n");
        w.append(indent).append("{\n");
        w.append(indent).append(CODE_INDENT).append("return jdoCandidate;\n");
        w.append(indent).append("}\n");
        w.append("\n");
        w.append(indent).append("public static " + qclassNameSimple + " parameter(String name)\n");
        w.append(indent).append("{\n");
        w.append(indent).append(CODE_INDENT).append("return new ").append(qclassNameSimple).append("(" + classNameSimple + ".class, name, ExpressionType.PARAMETER);\n");
        w.append(indent).append("}\n");
        w.append("\n");
        w.append(indent).append("public static " + qclassNameSimple + " variable(String name)\n");
        w.append(indent).append("{\n");
        w.append(indent).append(CODE_INDENT).append("return new ").append(qclassNameSimple).append("(" + classNameSimple + ".class, name, ExpressionType.VARIABLE);\n");
        w.append(indent).append("}\n");
    }

    protected void addConstructorWithPersistableExpression(Writer w, String indent, String qclassNameSimple, TypeElement superEl, List<? extends Element> members, String classNameFull, Map<String, TypeMirror> genericLookups) throws IOException {
        w.append(indent).append("public " + qclassNameSimple).append("(").append(PersistableExpression.class.getSimpleName() + " parent, String name, int depth)\n");
        w.append(indent).append("{\n");
        if (superEl != null) {
            w.append(indent).append(CODE_INDENT).append("super(parent, name, depth);\n");
        } else {
            w.append(indent).append(CODE_INDENT).append("super(parent, name);\n");
        }
        if (this.queryMode == 1 && members != null) {
            for (Element element : members) {
                if (element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)element))) continue;
                TypeMirror type = AnnotationProcessorUtils.getDeclaredType(element);
                if (type instanceof TypeVariable && genericLookups != null && genericLookups.containsKey(type.toString())) {
                    type = genericLookups.get(type.toString());
                }
                String memberName = AnnotationProcessorUtils.getMemberName(element);
                String implClassName = this.getExpressionImplClassNameForType(type);
                if (implClassName.startsWith(classNameFull + ".")) {
                    implClassName = implClassName.substring(classNameFull.length() + 1);
                }
                if (this.isPersistableType(type)) {
                    w.append(indent).append(CODE_INDENT).append("if (depth > 0)\n");
                    w.append(indent).append(CODE_INDENT).append("{\n");
                    w.append(indent).append(CODE_INDENT).append(CODE_INDENT).append("this.").append(memberName).append(" = new ").append(implClassName).append("(this, \"" + memberName + "\", depth-1);\n");
                    w.append(indent).append(CODE_INDENT).append("}\n");
                    w.append(indent).append(CODE_INDENT).append("else\n");
                    w.append(indent).append(CODE_INDENT).append("{\n");
                    w.append(indent).append(CODE_INDENT).append(CODE_INDENT).append("this.").append(memberName).append(" = null;\n");
                    w.append(indent).append(CODE_INDENT).append("}\n");
                    continue;
                }
                w.append(indent).append(CODE_INDENT).append("this.").append(memberName);
                w.append(" = new ").append(implClassName).append("(this, \"" + memberName + "\");\n");
            }
        }
        w.append(indent).append("}\n");
    }

    protected void addConstructorWithType(Writer w, String indent, String qclassNameSimple, List<? extends Element> members, String classNameFull, Map<String, TypeMirror> genericLookups) throws IOException {
        w.append(indent).append("public " + qclassNameSimple).append("(").append(Class.class.getSimpleName() + "<?> type, String name, ExpressionType exprType)\n");
        w.append(indent).append("{\n");
        w.append(indent).append(CODE_INDENT).append("super(type, name, exprType);\n");
        if (this.queryMode == 1 && members != null) {
            for (Element element : members) {
                if (element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)element))) continue;
                TypeMirror type = AnnotationProcessorUtils.getDeclaredType(element);
                if (type instanceof TypeVariable && genericLookups != null && genericLookups.containsKey(type.toString())) {
                    type = genericLookups.get(type.toString());
                }
                String memberName = AnnotationProcessorUtils.getMemberName(element);
                String implClassName = this.getExpressionImplClassNameForType(type);
                if (implClassName.startsWith(classNameFull + ".")) {
                    implClassName = implClassName.substring(classNameFull.length() + 1);
                }
                if (this.isPersistableType(type)) {
                    w.append(indent).append(CODE_INDENT).append("this.").append(memberName).append(" = new ").append(implClassName).append("(this, \"" + memberName + "\", " + this.fieldDepth + ");\n");
                    continue;
                }
                w.append(indent).append(CODE_INDENT).append("this.").append(memberName).append(" = new ").append(implClassName).append("(this, \"" + memberName + "\");\n");
            }
        }
        w.append(indent).append("}\n");
    }

    protected void addPropertyAccessorMethod(Writer w, String indent, Element member, String classNameFull, Map<String, TypeMirror> genericLookups) throws IOException {
        TypeMirror type = AnnotationProcessorUtils.getDeclaredType(member);
        if (type instanceof TypeVariable && genericLookups != null && genericLookups.containsKey(type.toString())) {
            type = genericLookups.get(type.toString());
        }
        String memberName = AnnotationProcessorUtils.getMemberName(member);
        String implClassName = this.getExpressionImplClassNameForType(type);
        if (implClassName.startsWith(classNameFull + ".")) {
            implClassName = implClassName.substring(classNameFull.length() + 1);
        }
        String intfName = this.getExpressionInterfaceNameForType(type);
        w.append(indent).append("public ").append(intfName).append(" ").append(memberName).append("()\n");
        w.append(indent).append("{\n");
        w.append(indent).append(CODE_INDENT).append("if (this.").append(memberName).append(" == null)\n");
        w.append(indent).append(CODE_INDENT).append("{\n");
        w.append(indent).append(CODE_INDENT).append(CODE_INDENT).append("this." + memberName).append(" = new ").append(implClassName).append("(this, \"" + memberName + "\");\n");
        w.append(indent).append(CODE_INDENT).append("}\n");
        w.append(indent).append(CODE_INDENT).append("return this.").append(memberName).append(";\n");
        w.append(indent).append("}\n");
    }

    private String getExpressionInterfaceNameForType(TypeMirror inputType) {
        String declTypeName;
        AnnotationProcessorUtils.TypeCategory cat;
        TypeMirror type = inputType;
        List<? extends TypeMirror> typeArgs = null;
        if (type.getKind() == TypeKind.DECLARED) {
            typeArgs = ((DeclaredType)type).getTypeArguments();
            type = ((DeclaredType)type).asElement().asType();
        }
        String typeName = type.toString();
        if (type.getKind() == TypeKind.BOOLEAN || Boolean.class.getName().equals(typeName)) {
            return BooleanExpression.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.BYTE || Byte.class.getName().equals(typeName)) {
            return ByteExpression.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.CHAR || Character.class.getName().equals(typeName)) {
            return CharacterExpression.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.DOUBLE || Double.class.getName().equals(typeName)) {
            return NumericExpression.class.getSimpleName() + "<Double>";
        }
        if (type.getKind() == TypeKind.FLOAT || Float.class.getName().equals(typeName)) {
            return NumericExpression.class.getSimpleName() + "<Float>";
        }
        if (type.getKind() == TypeKind.INT || Integer.class.getName().equals(typeName)) {
            return NumericExpression.class.getSimpleName() + "<Integer>";
        }
        if (type.getKind() == TypeKind.LONG || Long.class.getName().equals(typeName)) {
            return NumericExpression.class.getSimpleName() + "<Long>";
        }
        if (type.getKind() == TypeKind.SHORT || Short.class.getName().equals(typeName)) {
            return NumericExpression.class.getSimpleName() + "<Short>";
        }
        if (typeName.equals(BigInteger.class.getName())) {
            return NumericExpression.class.getSimpleName() + "<java.math.BigInteger>";
        }
        if (typeName.equals(BigDecimal.class.getName())) {
            return NumericExpression.class.getSimpleName() + "<java.math.BigDecimal>";
        }
        if (typeName.equals(String.class.getName())) {
            return StringExpression.class.getSimpleName();
        }
        if (typeName.equals(java.util.Date.class.getName())) {
            return DateTimeExpression.class.getSimpleName();
        }
        if (typeName.equals(Date.class.getName())) {
            return DateExpression.class.getSimpleName();
        }
        if (typeName.equals(Time.class.getName())) {
            return TimeExpression.class.getSimpleName();
        }
        if (typeName.equals(LocalDate.class.getName())) {
            return LocalDateExpression.class.getSimpleName();
        }
        if (typeName.equals(LocalTime.class.getName())) {
            return LocalTimeExpression.class.getSimpleName();
        }
        if (typeName.equals(LocalDateTime.class.getName())) {
            return LocalDateTimeExpression.class.getSimpleName();
        }
        if (typeName.startsWith(Optional.class.getName())) {
            if (typeArgs != null) {
                return OptionalExpression.class.getSimpleName() + "<" + typeArgs.get(0).toString() + ">";
            }
            return OptionalExpression.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && ((DeclaredType)type).asElement().getKind() == ElementKind.ENUM) {
            return EnumExpression.class.getSimpleName();
        }
        if (this.allowGeospatialExtensions) {
            if (typeName.startsWith("com.vividsolutions.jts.geom")) {
                if (typeName.equals("com.vividsolutions.jts.geom.Polygon")) {
                    return "javax.jdo.query.geospatial.PolygonExpression";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.Point")) {
                    return "javax.jdo.query.geospatial.PointExpression";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.LineString")) {
                    return "javax.jdo.query.geospatial.LineStringExpression";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.LinearRing")) {
                    return "javax.jdo.query.geospatial.LinearRingExpression";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.MultiLineString")) {
                    return "javax.jdo.query.geospatial.MultiLineStringExpression";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.MultiPoint")) {
                    return "javax.jdo.query.geospatial.MultiPointExpression";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.MultiPolygon")) {
                    return "javax.jdo.query.geospatial.MultiPolygonExpression";
                }
                return "javax.jdo.query.geospatial.GeometryExpression";
            }
            if (typeName.startsWith("org.postgis")) {
                if (typeName.equals("org.postgis.Polygon")) {
                    return "javax.jdo.query.geospatial.PolygonExpression";
                }
                if (typeName.equals("org.postgis.Point")) {
                    return "javax.jdo.query.geospatial.PointExpression";
                }
                if (typeName.equals("org.postgis.LineString")) {
                    return "javax.jdo.query.geospatial.LineStringExpression";
                }
                if (typeName.equals("org.postgis.LinearRing")) {
                    return "javax.jdo.query.geospatial.LinearRingExpression";
                }
                if (typeName.equals("org.postgis.MultiPolygon")) {
                    return "javax.jdo.query.geospatial.MultiPolygonExpression";
                }
                if (typeName.equals("org.postgis.MultiPoint")) {
                    return "javax.jdo.query.geospatial.MultiPointExpression";
                }
                if (typeName.equals("org.postgis.MultiLineString")) {
                    return "javax.jdo.query.geospatial.MultiLineStringExpression";
                }
                return "javax.jdo.query.geospatial.GeometryExpression";
            }
            if (typeName.equals("oracle.spatial.geometry.JGeometry")) {
                return "javax.jdo.query.geospatial.GeometryExpression";
            }
        }
        if ((cat = AnnotationProcessorUtils.getTypeCategoryForTypeMirror(declTypeName = AnnotationProcessorUtils.getDeclaredTypeName(this.processingEnv, type, true))) == AnnotationProcessorUtils.TypeCategory.MAP) {
            return MapExpression.class.getSimpleName();
        }
        if (cat == AnnotationProcessorUtils.TypeCategory.LIST) {
            return ListExpression.class.getSimpleName();
        }
        if (cat == AnnotationProcessorUtils.TypeCategory.COLLECTION || cat == AnnotationProcessorUtils.TypeCategory.SET) {
            return CollectionExpression.class.getSimpleName();
        }
        TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(type);
        if (typeElement != null && this.isPersistableType(typeElement)) {
            return declTypeName.substring(0, declTypeName.lastIndexOf(46) + 1) + JDOQueryProcessor.getQueryClassNameForClassName(declTypeName.substring(declTypeName.lastIndexOf(46) + 1));
        }
        String typeNameWithoutGenerics = typeName;
        if (typeName.indexOf("<") > 0) {
            typeNameWithoutGenerics = typeNameWithoutGenerics.substring(0, typeName.indexOf("<"));
        }
        return ObjectExpression.class.getSimpleName() + "<" + typeNameWithoutGenerics + ">";
    }

    private String getExpressionImplClassNameForType(TypeMirror inputType) {
        String declTypeName;
        AnnotationProcessorUtils.TypeCategory cat;
        TypeMirror type = inputType;
        List<? extends TypeMirror> typeArgs = null;
        if (type.getKind() == TypeKind.DECLARED) {
            typeArgs = ((DeclaredType)type).getTypeArguments();
            type = ((DeclaredType)type).asElement().asType();
        }
        String typeName = type.toString();
        if (type.getKind() == TypeKind.BOOLEAN || Boolean.class.getName().equals(typeName)) {
            return "BooleanExpressionImpl";
        }
        if (type.getKind() == TypeKind.BYTE || Byte.class.getName().equals(typeName)) {
            return "ByteExpressionImpl";
        }
        if (type.getKind() == TypeKind.CHAR || Character.class.getName().equals(typeName)) {
            return "CharacterExpressionImpl";
        }
        if (type.getKind() == TypeKind.DOUBLE || Double.class.getName().equals(typeName)) {
            return "NumericExpressionImpl<Double>";
        }
        if (type.getKind() == TypeKind.FLOAT || Float.class.getName().equals(typeName)) {
            return "NumericExpressionImpl<Float>";
        }
        if (type.getKind() == TypeKind.INT || Integer.class.getName().equals(typeName)) {
            return "NumericExpressionImpl<Integer>";
        }
        if (type.getKind() == TypeKind.LONG || Long.class.getName().equals(typeName)) {
            return "NumericExpressionImpl<Long>";
        }
        if (type.getKind() == TypeKind.SHORT || Short.class.getName().equals(typeName)) {
            return "NumericExpressionImpl<Short>";
        }
        if (typeName.equals(BigInteger.class.getName())) {
            return "NumericExpressionImpl<java.math.BigInteger>";
        }
        if (typeName.equals(BigDecimal.class.getName())) {
            return "NumericExpressionImpl<java.math.BigDecimal>";
        }
        if (typeName.equals(String.class.getName())) {
            return "StringExpressionImpl";
        }
        if (typeName.equals(java.util.Date.class.getName())) {
            return "DateTimeExpressionImpl";
        }
        if (typeName.equals(Date.class.getName())) {
            return "DateExpressionImpl";
        }
        if (typeName.equals(Time.class.getName())) {
            return "TimeExpressionImpl";
        }
        if (typeName.equals(LocalDate.class.getName())) {
            return "LocalDateExpressionImpl";
        }
        if (typeName.equals(LocalTime.class.getName())) {
            return "LocalTimeExpressionImpl";
        }
        if (typeName.equals(LocalDateTime.class.getName())) {
            return "LocalDateTimeExpressionImpl";
        }
        if (typeName.startsWith(Optional.class.getName())) {
            if (typeArgs != null) {
                return "OptionalExpressionImpl<" + typeArgs.get(0).toString() + ">";
            }
            return "OptionalExpressionImpl";
        }
        if (type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && ((DeclaredType)type).asElement().getKind() == ElementKind.ENUM) {
            return "EnumExpressionImpl";
        }
        if (this.allowGeospatialExtensions) {
            if (typeName.startsWith("com.vividsolutions.jts.geom")) {
                if (typeName.equals("com.vividsolutions.jts.geom.Polygon")) {
                    return "org.datanucleus.api.jdo.query.geospatial.PolygonExpressionImpl";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.Point")) {
                    return "org.datanucleus.api.jdo.query.geospatial.PointExpressionImpl";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.LineString")) {
                    return "org.datanucleus.api.jdo.query.geospatial.LineStringExpressionImpl";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.LinearRing")) {
                    return "org.datanucleus.api.jdo.query.geospatial.LinearRingExpressionImpl";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.MultiPolygon")) {
                    return "org.datanucleus.api.jdo.query.geospatial.MultiPolygonExpressionImpl";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.MultiPoint")) {
                    return "org.datanucleus.api.jdo.query.geospatial.MultiPointExpressionImpl";
                }
                if (typeName.equals("com.vividsolutions.jts.geom.MultiLineString")) {
                    return "org.datanucleus.api.jdo.query.geospatial.MultiLineStringExpressionImpl";
                }
                return "org.datanucleus.api.jdo.query.geospatial.GeometryExpressionImpl";
            }
            if (typeName.startsWith("org.postgis")) {
                if (typeName.equals("org.postgis.Polygon")) {
                    return "org.datanucleus.api.jdo.query.geospatial.PolygonExpressionImpl";
                }
                if (typeName.equals("org.postgis.Point")) {
                    return "org.datanucleus.api.jdo.query.geospatial.PointExpressionImpl";
                }
                if (typeName.equals("org.postgis.LineString")) {
                    return "org.datanucleus.api.jdo.query.geospatial.LineStringExpressionImpl";
                }
                if (typeName.equals("org.postgis.LinearRing")) {
                    return "org.datanucleus.api.jdo.query.geospatial.LinearRingExpressionImpl";
                }
                if (typeName.equals("org.postgis.MultiPolygon")) {
                    return "org.datanucleus.api.jdo.query.geospatial.MultiPolygonExpressionImpl";
                }
                if (typeName.equals("org.postgis.MultiPoint")) {
                    return "org.datanucleus.api.jdo.query.geospatial.MultiPointExpressionImpl";
                }
                if (typeName.equals("org.postgis.MultiLineString")) {
                    return "org.datanucleus.api.jdo.query.geospatial.MultiLineStringExpressionImpl";
                }
                return "org.datanucleus.api.jdo.query.geospatial.GeometryExpressionImpl";
            }
            if (typeName.equals("oracle.spatial.geometry.JGeometry")) {
                return "org.datanucleus.api.jdo.query.geospatial.GeometryExpressionImpl";
            }
        }
        if ((cat = AnnotationProcessorUtils.getTypeCategoryForTypeMirror(declTypeName = AnnotationProcessorUtils.getDeclaredTypeName(this.processingEnv, type, true))) == AnnotationProcessorUtils.TypeCategory.MAP) {
            return "MapExpressionImpl";
        }
        if (cat == AnnotationProcessorUtils.TypeCategory.LIST) {
            return "ListExpressionImpl";
        }
        if (cat == AnnotationProcessorUtils.TypeCategory.COLLECTION || cat == AnnotationProcessorUtils.TypeCategory.SET) {
            return "CollectionExpressionImpl";
        }
        TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(type);
        if (typeElement != null && this.isPersistableType(typeElement)) {
            return declTypeName.substring(0, declTypeName.lastIndexOf(46) + 1) + JDOQueryProcessor.getQueryClassNameForClassName(declTypeName.substring(declTypeName.lastIndexOf(46) + 1));
        }
        String typeNameWithoutGenerics = typeName;
        if (typeName.indexOf("<") > 0) {
            typeNameWithoutGenerics = typeNameWithoutGenerics.substring(0, typeName.indexOf("<"));
        }
        return "ObjectExpressionImpl<" + typeNameWithoutGenerics + ">";
    }

    private boolean isPersistableType(TypeMirror type) {
        TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(type);
        return typeElement != null && this.isPersistableType(typeElement);
    }

    private boolean isPersistableType(TypeElement el) {
        if (el == null) {
            return false;
        }
        return el.getAnnotation(PersistenceCapable.class) != null;
    }

    private static List<? extends Element> getPersistentMembers(TypeElement el) {
        List<? extends Element> members = AnnotationProcessorUtils.getFieldMembers(el);
        if (members != null) {
            Iterator<? extends Element> iter = members.iterator();
            while (iter.hasNext()) {
                Element member = iter.next();
                boolean persistent = true;
                if (member.getModifiers().contains((Object)Modifier.STATIC)) {
                    persistent = false;
                } else {
                    List<? extends AnnotationMirror> annots = member.getAnnotationMirrors();
                    if (annots != null) {
                        for (AnnotationMirror annotationMirror : annots) {
                            if (!annotationMirror.getAnnotationType().toString().equals(NotPersistent.class.getName())) continue;
                            persistent = false;
                            break;
                        }
                    }
                }
                if (persistent) continue;
                iter.remove();
            }
        }
        return members;
    }

    public TypeElement getPersistentSupertype(TypeElement element) {
        TypeMirror superType = element.getSuperclass();
        if (superType == null || Object.class.getName().equals(element.toString())) {
            return null;
        }
        TypeElement superElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superType);
        if (superElement == null || this.isPersistableType(superElement)) {
            return superElement;
        }
        return this.getPersistentSupertype(superElement);
    }

    public static String getQueryClassNameForClassName(String name) {
        return "Q" + name;
    }
}

