/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa.query;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.AccessType;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.tools.JavaFileObject;
import org.datanucleus.util.AnnotationProcessorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"javax.persistence.Entity", "javax.persistence.Embeddable", "javax.persistence.MappedSuperclass"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JPACriteriaProcessor
extends AbstractProcessor {
    String suffix = "_";
    Types typesHandler;
    protected static Class[] annotationsWithTargetEntity = new Class[]{OneToOne.class, OneToMany.class, ManyToOne.class, ManyToMany.class};

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        this.typesHandler = this.processingEnv.getTypeUtils();
        Set<? extends Element> elements = roundEnv.getRootElements();
        for (Element element : elements) {
            this.processClass((TypeElement)element);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClass(TypeElement el) {
        if (el == null || !JPACriteriaProcessor.isJPAAnnotated(el)) {
            return;
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        String className = elementUtils.getBinaryName(el).toString();
        String pkgName = className.substring(0, className.lastIndexOf(46));
        String classSimpleName = className.substring(className.lastIndexOf(46) + 1);
        String classNameNew = className + this.suffix;
        System.out.println("DataNucleus : JPA Criteria - " + className + " -> " + classNameNew);
        TypeElement superEl = this.getPersistentSupertype(el);
        try {
            JavaFileObject javaFile = this.processingEnv.getFiler().createSourceFile(classNameNew, new Element[0]);
            Writer w = javaFile.openWriter();
            try {
                w.append("package " + pkgName + ";\n");
                w.append("\n");
                w.append("import javax.persistence.metamodel.*;\n");
                w.append("\n");
                w.append("@StaticMetamodel(" + classSimpleName + ".class)\n");
                w.append("public class " + classSimpleName + this.suffix);
                if (superEl != null) {
                    String superClassName = elementUtils.getBinaryName(superEl).toString();
                    w.append(" extends ").append(superClassName + this.suffix);
                }
                w.append("\n");
                w.append("{\n");
                AccessType clsAccessType = (AccessType)AnnotationProcessorUtils.getValueForAnnotationAttribute((Element)el, AccessType.class, (String)"value");
                List<Object> members = null;
                members = clsAccessType == AccessType.FIELD ? AnnotationProcessorUtils.getFieldMembers((TypeElement)el) : (clsAccessType == AccessType.PROPERTY ? AnnotationProcessorUtils.getPropertyMembers((TypeElement)el) : JPACriteriaProcessor.getDefaultAccessMembers(el));
                if (members != null) {
                    for (Element element : members) {
                        boolean isTransient = false;
                        List<? extends AnnotationMirror> annots = element.getAnnotationMirrors();
                        if (annots != null) {
                            for (AnnotationMirror annotationMirror : annots) {
                                if (!annotationMirror.getAnnotationType().toString().equals(Transient.class.getName())) continue;
                                isTransient = true;
                                break;
                            }
                        }
                        if (isTransient || element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)((ExecutableElement)element)))) continue;
                        TypeMirror type = AnnotationProcessorUtils.getDeclaredType((Element)element);
                        String string = AnnotationProcessorUtils.getDeclaredTypeName((ProcessingEnvironment)this.processingEnv, (TypeMirror)type, (boolean)true);
                        AnnotationProcessorUtils.TypeCategory cat = AnnotationProcessorUtils.getTypeCategoryForTypeMirror((String)string);
                        String memberName = AnnotationProcessorUtils.getMemberName((Element)element);
                        w.append("    public static volatile " + cat.getTypeName());
                        w.append("<" + classSimpleName + ", ");
                        if (cat == AnnotationProcessorUtils.TypeCategory.ATTRIBUTE) {
                            if (type instanceof PrimitiveType) {
                                if (((Object)type).toString().equals("long")) {
                                    w.append("Long");
                                } else if (((Object)type).toString().equals("int")) {
                                    w.append("Integer");
                                } else if (((Object)type).toString().equals("short")) {
                                    w.append("Short");
                                } else if (((Object)type).toString().equals("float")) {
                                    w.append("Float");
                                } else if (((Object)type).toString().equals("double")) {
                                    w.append("Double");
                                } else if (((Object)type).toString().equals("char")) {
                                    w.append("Character");
                                } else if (((Object)type).toString().equals("byte")) {
                                    w.append("Byte");
                                } else if (((Object)type).toString().equals("boolean")) {
                                    w.append("Boolean");
                                } else {
                                    w.append(((Object)type).toString());
                                }
                            } else {
                                w.append(((Object)type).toString());
                            }
                        } else if (cat == AnnotationProcessorUtils.TypeCategory.MAP) {
                            TypeMirror keyType = this.getTypeParameter(element, type, 0, false);
                            String keyTypeName = AnnotationProcessorUtils.getDeclaredTypeName((ProcessingEnvironment)this.processingEnv, (TypeMirror)keyType, (boolean)true);
                            TypeMirror valueType = this.getTypeParameter(element, type, 1, true);
                            String valueTypeName = AnnotationProcessorUtils.getDeclaredTypeName((ProcessingEnvironment)this.processingEnv, (TypeMirror)valueType, (boolean)true);
                            w.append(keyTypeName + ", " + valueTypeName);
                        } else {
                            TypeMirror elementType = this.getTypeParameter(element, type, 0, true);
                            String elementTypeName = AnnotationProcessorUtils.getDeclaredTypeName((ProcessingEnvironment)this.processingEnv, (TypeMirror)elementType, (boolean)true);
                            w.append(elementTypeName);
                        }
                        w.append("> " + memberName + ";\n");
                    }
                }
                w.append("}\n");
                w.flush();
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    TypeMirror getTypeParameter(Element element, TypeMirror type, int position, boolean checkTarget) {
        List<? extends TypeMirror> params;
        if (type.getKind() == TypeKind.ARRAY) {
            return ((ArrayType)type).getComponentType();
        }
        if (type.getKind() != TypeKind.DECLARED) {
            return null;
        }
        if (checkTarget) {
            TypeMirror target = null;
            for (int i = 0; i < annotationsWithTargetEntity.length; ++i) {
                Object targetValue = AnnotationProcessorUtils.getValueForAnnotationAttribute((Element)element, (Class)annotationsWithTargetEntity[i], (String)"targetEntity");
                if (targetValue == null) continue;
                target = (TypeMirror)targetValue;
                break;
            }
            if (target != null) {
                return target;
            }
        }
        NullType param = (params = ((DeclaredType)type).getTypeArguments()) == null || params.size() < position + 1 ? this.typesHandler.getNullType() : params.get(position);
        return param;
    }

    public TypeElement getPersistentSupertype(TypeElement element) {
        TypeMirror superType = element.getSuperclass();
        if (superType == null || element != null && "java.lang.Object".equals(element.toString())) {
            return null;
        }
        TypeElement superElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superType);
        if (JPACriteriaProcessor.isJPAAnnotated(superElement)) {
            return superElement;
        }
        return this.getPersistentSupertype(superElement);
    }

    public static List<? extends Element> getDefaultAccessMembers(TypeElement el) {
        for (Element element : el.getEnclosedElements()) {
            ExecutableElement method;
            if (!AnnotationProcessorUtils.isMethod((Element)element) || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)(method = (ExecutableElement)element)) && !AnnotationProcessorUtils.isJavaBeanSetter((ExecutableElement)method)) continue;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                String annTypeName = annotationMirror.getAnnotationType().toString();
                if (!annTypeName.startsWith("javax.persistence")) continue;
                return AnnotationProcessorUtils.getPropertyMembers((TypeElement)el);
            }
        }
        return AnnotationProcessorUtils.getFieldMembers((TypeElement)el);
    }

    public static boolean isJPAAnnotated(TypeElement el) {
        return el.getAnnotation(Entity.class) != null || el.getAnnotation(MappedSuperclass.class) != null || el.getAnnotation(Embeddable.class) != null;
    }
}

