/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPoolFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class DefaultConnectionPoolFactory
implements ConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        Properties props = AbstractConnectionPoolFactory.getPropertiesForDriver(storeMgr);
        if (props.size() == 2) {
            props = null;
        }
        return new DefaultConnectionPool(new DriverManagerDataSource(storeMgr.getConnectionDriverName(), storeMgr.getConnectionURL(), storeMgr.getConnectionUserName(), storeMgr.getConnectionPassword(), storeMgr.getNucleusContext().getClassLoaderResolver(null), props));
    }

    public static class DriverManagerDataSource
    implements DataSource {
        private final String driverName;
        private final String url;
        private final ClassLoaderResolver clr;
        private final String userName;
        private final String password;
        private final Properties props;

        public DriverManagerDataSource(String driverName, String url, String userName, String password, ClassLoaderResolver clr, Properties props) {
            this.driverName = driverName;
            this.url = url;
            this.clr = clr;
            this.userName = userName;
            this.password = password;
            this.props = props;
            if (driverName != null) {
                try {
                    clr.classForName(driverName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    try {
                        Class.forName(driverName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e2) {
                        throw new NucleusUserException(Localiser.msg((String)"047006", (Object[])new Object[]{driverName}), (Throwable)e).setFatal();
                    }
                }
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (StringUtils.isWhitespace((String)this.driverName)) {
                throw new NucleusUserException(Localiser.msg((String)"047007"));
            }
            return this.getConnection(this.userName, this.password);
        }

        @Override
        public Connection getConnection(String userName, String password) throws SQLException {
            try {
                Properties info = new Properties();
                if (userName != null) {
                    info.put("user", this.userName);
                }
                if (password != null) {
                    info.put("password", this.password);
                }
                if (this.props != null) {
                    info.putAll((Map<?, ?>)this.props);
                }
                return ((Driver)this.clr.classForName(this.driverName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).connect(this.url, info);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                try {
                    return DriverManager.getConnection(this.url, this.userName, this.password);
                }
                catch (Exception e2) {
                    throw new NucleusUserException(Localiser.msg((String)"047006", (Object[])new Object[]{this.driverName}), (Throwable)e).setFatal();
                }
            }
        }

        @Override
        public PrintWriter getLogWriter() {
            return DriverManager.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) {
            DriverManager.setLogWriter(out);
        }

        @Override
        public int getLoginTimeout() {
            return DriverManager.getLoginTimeout();
        }

        @Override
        public void setLoginTimeout(int seconds) {
            DriverManager.setLoginTimeout(seconds);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DriverManagerDataSource)) {
                return false;
            }
            DriverManagerDataSource dmds = (DriverManagerDataSource)obj;
            if (this.driverName == null ? dmds.driverName != null : !this.driverName.equals(dmds.driverName)) {
                return false;
            }
            return !(this.url == null ? dmds.url != null : !this.url.equals(dmds.url));
        }

        public int hashCode() {
            return (this.driverName == null ? 0 : this.driverName.hashCode()) ^ (this.url == null ? 0 : this.url.hashCode());
        }

        public Object unwrap(Class iface) throws SQLException {
            if (!DataSource.class.equals((Object)iface)) {
                throw new SQLException("DataSource of type [" + this.getClass().getName() + "] can only be unwrapped as [javax.sql.DataSource], not as [" + iface.getName() + "]");
            }
            return this;
        }

        public boolean isWrapperFor(Class iface) throws SQLException {
            return DataSource.class.equals((Object)iface);
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }
    }

    public class DefaultConnectionPool
    implements ConnectionPool {
        final DataSource dataSource;

        public DefaultConnectionPool(DataSource ds) {
            this.dataSource = ds;
        }

        @Override
        public void close() {
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

