/**********************************************************************
Copyright (c) 2011 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;

import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;

/**
 * Expression for an aggregate function.
 * Allows us to distinguish aggregate expressions from other temporal expressions.
 */
public class AggregateTemporalExpression extends TemporalExpression implements AggregateExpression
{
    public AggregateTemporalExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List<SQLExpression> args)
    {
        super(stmt, mapping, functionName, args);
    }
}