/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Date;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BinaryExpression;
import org.datanucleus.store.rdbms.sql.expression.DelegatedExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class TypeConverterExpression
extends DelegatedExpression {
    public TypeConverterExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
        if (!(mapping instanceof TypeConverterMapping)) {
            throw new NucleusException(Localiser.msg((String)"060019", (Object[])new Object[]{mapping.getClass().getName()}));
        }
        TypeConverterMapping convMapping = (TypeConverterMapping)mapping;
        TypeConverter conv = convMapping.getTypeConverter();
        Class datastoreType = stmt.getRDBMSManager().getNucleusContext().getTypeManager().getDatastoreTypeForTypeConverter(conv, convMapping.getJavaType());
        if (datastoreType == String.class) {
            this.delegate = new StringExpression(stmt, table, mapping);
        } else if (Date.class.isAssignableFrom(datastoreType)) {
            this.delegate = new TemporalExpression(stmt, table, mapping);
        } else if (Number.class.isAssignableFrom(datastoreType)) {
            this.delegate = new NumericExpression(stmt, table, mapping);
        } else if (Byte[].class.isAssignableFrom(datastoreType) || byte[].class.isAssignableFrom(datastoreType)) {
            this.delegate = new BinaryExpression(stmt, table, mapping);
        } else {
            throw new NucleusException(Localiser.msg((String)"060017", (Object[])new Object[]{mapping.getClass().getName(), datastoreType.getName()}));
        }
    }

    @Override
    public SQLExpression invoke(String methodName, List<SQLExpression> args) {
        String typeName = this.mapping.getJavaType().getName();
        try {
            return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, typeName, methodName, this, args);
        }
        catch (NucleusException ne) {
            if (this.delegate instanceof StringExpression) {
                typeName = String.class.getName();
                NucleusLogger.QUERY.info((Object)Localiser.msg((String)"060018", (Object[])new Object[]{methodName, this.mapping.getJavaType().getName(), typeName}));
                return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, typeName, methodName, this, args);
            }
            throw ne;
        }
    }
}

