/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.StreamableSpooler;
import org.datanucleus.store.rdbms.mapping.java.FileMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class BinaryStreamColumnMapping
extends AbstractColumnMapping {
    public BinaryStreamColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    @Override
    public int getJDBCType() {
        return -4;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        block5: {
            try {
                if (value == null) {
                    ps.setNull(param, this.getJDBCType());
                    break block5;
                }
                if (value instanceof File) {
                    File file = (File)value;
                    ps.setBinaryStream(param, (InputStream)new FileInputStream(file), (int)file.length());
                    break block5;
                }
                throw new NucleusDataStoreException("setObject unsupported for java type " + value.getClass().getName());
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
            }
        }
    }

    @Override
    public Object getObject(ResultSet resultSet, int param) {
        File so;
        block4: {
            so = null;
            try {
                InputStream is = resultSet.getBinaryStream(param);
                if (resultSet.wasNull()) break block4;
                if (this.getJavaTypeMapping() instanceof FileMapping) {
                    so = StreamableSpooler.instance().spoolStream(is);
                    break block4;
                }
                throw new NucleusDataStoreException("getObject unsupported for java type mapping of type " + this.getJavaTypeMapping());
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
            }
        }
        return so;
    }
}

