/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;

public abstract class MultiMapping
extends JavaTypeMapping {
    protected JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    protected int numberOfColumnMappings = 0;

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    @Override
    public int getNumberOfColumnMappings() {
        if (this.numberOfColumnMappings == 0) {
            int numDatastoreTmp = 0;
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                numDatastoreTmp += this.javaTypeMappings[i].getNumberOfColumnMappings();
            }
            this.numberOfColumnMappings = numDatastoreTmp;
        }
        return this.numberOfColumnMappings;
    }

    @Override
    public ColumnMapping[] getColumnMappings() {
        if (this.columnMappings.length == 0) {
            ColumnMapping[] colMappings = new ColumnMapping[this.getNumberOfColumnMappings()];
            int num = 0;
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                for (int j = 0; j < this.javaTypeMappings[i].getNumberOfColumnMappings(); ++j) {
                    colMappings[num++] = this.javaTypeMappings[i].getColumnMapping(j);
                }
            }
            this.columnMappings = colMappings;
        }
        return super.getColumnMappings();
    }

    @Override
    public ColumnMapping getColumnMapping(int index) {
        if (index >= this.getNumberOfColumnMappings()) {
            throw new NucleusException("Attempt to get ColumnMapping with index " + index + " when total number of mappings is " + this.numberOfColumnMappings + " for field=" + this.mmd).setFatal();
        }
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberColumnMappings = this.javaTypeMappings[i].getNumberOfColumnMappings();
            for (int j = 0; j < numberColumnMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getColumnMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new NucleusException("Invalid index " + index + " for ColumnMapping (numColumns=" + this.getNumberOfColumnMappings() + "), for field=" + this.mmd).setFatal();
    }
}

