/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.datanucleus.maven.AbstractDataNucleusMojo;

public abstract class AbstractEnhancerMojo
extends AbstractDataNucleusMojo {
    private static final String TOOL_NAME_DATANUCLEUS_ENHANCER = "org.datanucleus.enhancer.DataNucleusEnhancer";
    protected String enhancerName;
    protected boolean quiet;
    protected boolean generatePK;
    protected boolean generateConstructor;
    protected boolean detachListener;

    protected void executeDataNucleusTool(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        this.enhance(pluginArtifacts, files);
    }

    protected void enhance(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        ArrayList<String> cpEntries = new ArrayList<String>();
        Iterator it = pluginArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            try {
                String artifactPath = artifact.getFile().getCanonicalPath();
                if (cpEntries.contains(artifactPath)) continue;
                cpEntries.add(artifactPath);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        Iterator uniqueIter = this.getUniqueClasspathElements().iterator();
        while (uniqueIter.hasNext()) {
            String entry = (String)uniqueIter.next();
            if (cpEntries.contains(entry)) continue;
            cpEntries.add(entry);
        }
        StringBuffer cpBuffer = new StringBuffer();
        Iterator it2 = cpEntries.iterator();
        while (it2.hasNext()) {
            cpBuffer.append((String)it2.next());
            if (!it2.hasNext()) continue;
            cpBuffer.append(File.pathSeparator);
        }
        if (this.fork) {
            Commandline cl = new Commandline();
            cl.setExecutable("java");
            cl.createArgument().setValue("-cp");
            cl.createArgument().setValue(cpBuffer.toString());
            URL log4jURL = this.getLog4JConfiguration();
            if (log4jURL != null) {
                cl.createArgument().setValue("-Dlog4j.configuration=" + log4jURL);
            } else {
                URL jdkLogURL = this.getJdkLogConfiguration();
                if (jdkLogURL != null) {
                    cl.createArgument().setValue("-Djava.util.logging.config.file=" + jdkLogURL);
                }
            }
            cl.createArgument().setValue(TOOL_NAME_DATANUCLEUS_ENHANCER);
            this.prepareModeSpecificCommandLineArguments(cl, null);
            if (this.quiet) {
                cl.createArgument().setValue("-q");
            } else if (this.verbose) {
                cl.createArgument().setValue("-v");
            }
            if (this.persistenceUnitName != null && this.persistenceUnitName.trim().length() > 0) {
                cl.createArgument().setLine("-pu " + this.persistenceUnitName);
            }
            cl.createArgument().setLine("-enhancerName " + this.enhancerName);
            cl.createArgument().setLine("-api " + this.api);
            if (!this.generatePK) {
                cl.createArgument().setLine("-generatePK false");
            }
            if (!this.generateConstructor) {
                cl.createArgument().setLine("-generateConstructor false");
            }
            if (this.detachListener) {
                cl.createArgument().setLine("-detachListener true");
            }
            Iterator it3 = files.iterator();
            while (it3.hasNext()) {
                File file = (File)it3.next();
                cl.createArgument().setValue(file.getAbsolutePath());
            }
            this.executeCommandLine(cl);
        } else {
            ArrayList<String> args = new ArrayList<String>();
            this.prepareModeSpecificCommandLineArguments(null, args);
            if (this.quiet) {
                args.add("-q");
            } else if (this.verbose) {
                args.add("-v");
            }
            if (this.persistenceUnitName != null && this.persistenceUnitName.trim().length() > 0) {
                args.add("-pu");
                args.add(this.persistenceUnitName);
            }
            args.add("-enhancerName");
            args.add(this.enhancerName);
            args.add("-api");
            args.add(this.api);
            if (!this.generatePK) {
                args.add("-generatePK");
                args.add("false");
            }
            if (!this.generateConstructor) {
                args.add("-generateConstructor");
                args.add("false");
            }
            if (this.detachListener) {
                args.add("-detachListener");
                args.add("true");
            }
            Iterator it4 = files.iterator();
            while (it4.hasNext()) {
                File file = (File)it4.next();
                args.add(file.getAbsolutePath());
            }
            this.executeInJvm(TOOL_NAME_DATANUCLEUS_ENHANCER, args, cpEntries, this.quiet);
        }
    }

    protected abstract void prepareModeSpecificCommandLineArguments(Commandline var1, List var2);

    protected String getToolName() {
        return TOOL_NAME_DATANUCLEUS_ENHANCER;
    }
}

