/*
 * Decompiled with CFR 0.152.
 */
package org.datarocks.banzai.configuration;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class HandlerConfiguration {
    private final Map<String, Object> configurationItems;

    public Optional<Object> getConfigurationItem(@NonNull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key is marked non-null but is null");
        if (this.configurationItems == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.configurationItems.get(key));
    }

    public <T> Optional<T> getConfigurationItem(Class<T> clazz, @NonNull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key is marked non-null but is null");
        if (this.configurationItems == null) {
            return Optional.empty();
        }
        Object configurationItem = this.configurationItems.get(key);
        if (configurationItem == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(clazz.cast(configurationItem));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Generated
    HandlerConfiguration(Map<String, Object> configurationItems) {
        this.configurationItems = configurationItems;
    }

    @Generated
    public static HandlerConfigurationBuilder builder() {
        return new HandlerConfigurationBuilder();
    }

    public static class HandlerConfigurationBuilder {
        @Generated
        private Map<String, Object> configurationItems;

        public HandlerConfigurationBuilder handlerConfigurationItem(@NonNull String key, @NonNull Object value) {
            Preconditions.checkNotNull((Object)key, (Object)"key is marked non-null but is null");
            Preconditions.checkNotNull((Object)value, (Object)"value is marked non-null but is null");
            if (this.configurationItems == null) {
                this.configurationItems = new HashMap<String, Object>();
            }
            this.configurationItems.put(key, value);
            return this;
        }

        @Generated
        HandlerConfigurationBuilder() {
        }

        @Generated
        public HandlerConfigurationBuilder configurationItems(Map<String, Object> configurationItems) {
            this.configurationItems = configurationItems;
            return this;
        }

        @Generated
        public HandlerConfiguration build() {
            return new HandlerConfiguration(this.configurationItems);
        }

        @Generated
        public String toString() {
            return "HandlerConfiguration.HandlerConfigurationBuilder(configurationItems=" + this.configurationItems + ")";
        }
    }
}

