/*
 * Decompiled with CFR 0.152.
 */
package org.datarocks.banzai.examples.bibjsonpipe;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.datarocks.banzai.examples.bibjsonpipe.Author;
import org.datarocks.banzai.examples.bibjsonpipe.Bibliography;
import org.datarocks.banzai.processor.AbstractSingleItemProcessor;

public class BibliographyCapitalizeProcessor
extends AbstractSingleItemProcessor<Bibliography> {
    @Override
    public Bibliography processImpl(@NonNull String correlationId, @NonNull Bibliography bibliography) {
        Preconditions.checkNotNull((Object)correlationId, (Object)"correlationId is marked non-null but is null");
        Preconditions.checkNotNull((Object)bibliography, (Object)"bibliography is marked non-null but is null");
        bibliography.setAuthor(bibliography.getAuthor().stream().map(author -> new Author(author.name.toUpperCase(Locale.ROOT))).collect(Collectors.toList()));
        return bibliography;
    }

    @Generated
    protected BibliographyCapitalizeProcessor(BibliographyCapitalizeProcessorBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static BibliographyCapitalizeProcessorBuilder<?, ?> builder() {
        return new BibliographyCapitalizeProcessorBuilderImpl();
    }

    @Generated
    private static final class BibliographyCapitalizeProcessorBuilderImpl
    extends BibliographyCapitalizeProcessorBuilder<BibliographyCapitalizeProcessor, BibliographyCapitalizeProcessorBuilderImpl> {
        @Generated
        private BibliographyCapitalizeProcessorBuilderImpl() {
        }

        @Override
        @Generated
        protected BibliographyCapitalizeProcessorBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BibliographyCapitalizeProcessor build() {
            return new BibliographyCapitalizeProcessor(this);
        }
    }

    @Generated
    public static abstract class BibliographyCapitalizeProcessorBuilder<C extends BibliographyCapitalizeProcessor, B extends BibliographyCapitalizeProcessorBuilder<C, B>>
    extends AbstractSingleItemProcessor.AbstractSingleItemProcessorBuilder<Bibliography, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BibliographyCapitalizeProcessor.BibliographyCapitalizeProcessorBuilder(super=" + super.toString() + ")";
        }
    }
}

