/*
 * Decompiled with CFR 0.152.
 */
package org.datarocks.banzai.pipeline;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import org.datarocks.banzai.configuration.HandlerConfiguration;
import org.datarocks.banzai.pipeline.exception.HeadTransformerRequiredException;
import org.datarocks.banzai.pipeline.exception.TailsTransformerRequiredException;
import org.datarocks.banzai.processor.AbstractProcessor;
import org.datarocks.banzai.processor.AbstractSingleItemProcessor;
import org.datarocks.banzai.transformer.AbstractTransformer;

public class PipeLine<I, P, O> {
    private AbstractTransformer<I, P> abstractHeadTransformer;
    private AbstractTransformer<P, O> abstractTailTransformer;
    private AbstractSingleItemProcessor<P> processorChainHead;

    private PipeLine() {
    }

    public O process(@NonNull String correlationId, @NonNull I input) {
        Preconditions.checkNotNull((Object)correlationId, (Object)"correlationId is marked non-null but is null");
        Preconditions.checkNotNull(input, (Object)"input is marked non-null but is null");
        P processItem = this.abstractHeadTransformer.process(correlationId, input);
        if (this.processorChainHead != null) {
            processItem = this.processorChainHead.process(correlationId, processItem);
        }
        return this.abstractTailTransformer.process(correlationId, processItem);
    }

    public static <IC, PC, OC> PipeLineBuilder<IC, PC, OC> builder(@NonNull HandlerConfiguration handlerConfiguration, @NonNull Class<IC> inputClass, @NonNull Class<PC> processClass, @NonNull Class<OC> outputClass) {
        Preconditions.checkNotNull((Object)handlerConfiguration, (Object)"handlerConfiguration is marked non-null but is null");
        Preconditions.checkNotNull(inputClass, (Object)"inputClass is marked non-null but is null");
        Preconditions.checkNotNull(processClass, (Object)"processClass is marked non-null but is null");
        Preconditions.checkNotNull(outputClass, (Object)"outputClass is marked non-null but is null");
        return new PipeLineBuilder<IC, PC, OC>(handlerConfiguration, inputClass, processClass, outputClass);
    }

    public static class PipeLineBuilder<INPUT, PROCESS, OUTPUT> {
        private AbstractTransformer<INPUT, PROCESS> abstractHeadTransformer;
        private AbstractTransformer<PROCESS, OUTPUT> abstractTailTransformer;
        private AbstractSingleItemProcessor<PROCESS> processorChainHead;
        private AbstractProcessor<PROCESS> processorChainTail;
        private final HandlerConfiguration handlerConfiguration;
        private final Class<INPUT> inputClass;
        private final Class<PROCESS> processClass;
        private final Class<OUTPUT> outputClass;

        private PipeLineBuilder(@NonNull HandlerConfiguration handlerConfiguration, @NonNull Class<INPUT> inputClass, @NonNull Class<PROCESS> processClass, @NonNull Class<OUTPUT> outputClass) {
            Preconditions.checkNotNull((Object)handlerConfiguration, (Object)"handlerConfiguration is marked non-null but is null");
            Preconditions.checkNotNull(inputClass, (Object)"inputClass is marked non-null but is null");
            Preconditions.checkNotNull(processClass, (Object)"processClass is marked non-null but is null");
            Preconditions.checkNotNull(outputClass, (Object)"outputClass is marked non-null but is null");
            this.handlerConfiguration = handlerConfiguration;
            this.inputClass = inputClass;
            this.processClass = processClass;
            this.outputClass = outputClass;
        }

        private Class<?> getInputClass() {
            return this.inputClass;
        }

        private Class<?> getProcessClass() {
            return this.processClass;
        }

        private Class<?> getOutputClass() {
            return this.outputClass;
        }

        public PipeLine<INPUT, PROCESS, OUTPUT> build() {
            PipeLine pipeLine = new PipeLine();
            if (this.abstractHeadTransformer == null) {
                throw new HeadTransformerRequiredException();
            }
            if (this.abstractTailTransformer == null) {
                throw new TailsTransformerRequiredException();
            }
            pipeLine.abstractHeadTransformer = this.abstractHeadTransformer;
            pipeLine.abstractTailTransformer = this.abstractTailTransformer;
            pipeLine.processorChainHead = this.processorChainHead;
            return pipeLine;
        }

        public PipeLineBuilder<INPUT, PROCESS, OUTPUT> addHeadTransformer(@NonNull AbstractTransformer<INPUT, PROCESS> headTransformer) {
            Preconditions.checkNotNull(headTransformer, (Object)"headTransformer is marked non-null but is null");
            headTransformer.setHandlerConfiguration(this.handlerConfiguration);
            this.abstractHeadTransformer = headTransformer;
            return this;
        }

        public PipeLineBuilder<INPUT, PROCESS, OUTPUT> addTailTransformer(@NonNull AbstractTransformer<PROCESS, OUTPUT> tailTransformer) {
            Preconditions.checkNotNull(tailTransformer, (Object)"tailTransformer is marked non-null but is null");
            tailTransformer.setHandlerConfiguration(this.handlerConfiguration);
            this.abstractTailTransformer = tailTransformer;
            return this;
        }

        public PipeLineBuilder<INPUT, PROCESS, OUTPUT> addStep(@NonNull AbstractSingleItemProcessor<PROCESS> processStep) {
            Preconditions.checkNotNull(processStep, (Object)"processStep is marked non-null but is null");
            processStep.setHandlerConfiguration(this.handlerConfiguration);
            if (this.processorChainHead == null) {
                this.processorChainHead = processStep;
            } else {
                this.processorChainTail.setNextProcessor(processStep);
            }
            this.processorChainTail = processStep;
            return this;
        }
    }
}

