/*
 * Decompiled with CFR 0.152.
 */
package org.datarocks.banzai.processor;

import com.google.common.base.Preconditions;
import lombok.Generated;
import lombok.NonNull;
import org.datarocks.banzai.configuration.HandlerConfiguration;
import org.datarocks.banzai.event.ProcessorEventListener;
import org.datarocks.banzai.exception.HandlerConfigurationMissingException;
import org.datarocks.banzai.processor.AbstractSingleItemProcessor;

public abstract class AbstractProcessor<T> {
    protected AbstractSingleItemProcessor<T> singleItemProcessor;
    private HandlerConfiguration handlerConfiguration;
    protected ProcessorEventListener processorEventListener;

    public HandlerConfiguration getHandlerConfiguration() {
        if (this.handlerConfiguration == null) {
            throw new HandlerConfigurationMissingException();
        }
        return this.handlerConfiguration;
    }

    public void setHandlerConfiguration(@NonNull HandlerConfiguration handlerConfiguration) {
        Preconditions.checkNotNull((Object)handlerConfiguration, (Object)"handlerConfiguration is marked non-null but is null");
        this.handlerConfiguration = handlerConfiguration;
    }

    public void setNextProcessor(AbstractSingleItemProcessor<T> processor) {
        this.singleItemProcessor = processor;
    }

    protected AbstractSingleItemProcessor<T> getNextProcessor() {
        return this.singleItemProcessor;
    }

    @Generated
    protected AbstractProcessor(AbstractProcessorBuilder<T, ?, ?> b) {
        this.singleItemProcessor = b.singleItemProcessor;
        this.handlerConfiguration = b.handlerConfiguration;
        this.processorEventListener = b.processorEventListener;
    }

    @Generated
    public static abstract class AbstractProcessorBuilder<T, C extends AbstractProcessor<T>, B extends AbstractProcessorBuilder<T, C, B>> {
        @Generated
        private AbstractSingleItemProcessor<T> singleItemProcessor;
        @Generated
        private HandlerConfiguration handlerConfiguration;
        @Generated
        private ProcessorEventListener processorEventListener;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B singleItemProcessor(AbstractSingleItemProcessor<T> singleItemProcessor) {
            this.singleItemProcessor = singleItemProcessor;
            return this.self();
        }

        @Generated
        public B handlerConfiguration(HandlerConfiguration handlerConfiguration) {
            this.handlerConfiguration = handlerConfiguration;
            return this.self();
        }

        @Generated
        public B processorEventListener(ProcessorEventListener processorEventListener) {
            this.processorEventListener = processorEventListener;
            return this.self();
        }

        @Generated
        public String toString() {
            return "AbstractProcessor.AbstractProcessorBuilder(singleItemProcessor=" + this.singleItemProcessor + ", handlerConfiguration=" + this.handlerConfiguration + ", processorEventListener=" + this.processorEventListener + ")";
        }
    }
}

