/*
 * Decompiled with CFR 0.152.
 */
package org.datarocks.banzai.transformer;

import com.google.common.base.Preconditions;
import lombok.Generated;
import lombok.NonNull;
import org.datarocks.banzai.configuration.HandlerConfiguration;
import org.datarocks.banzai.event.ProcessorEventListener;
import org.datarocks.banzai.processor.AbstractSingleItemProcessor;

public abstract class AbstractTransformer<I, O> {
    protected HandlerConfiguration handlerConfiguration;
    protected ProcessorEventListener processorEventListener;
    protected AbstractSingleItemProcessor<O> nextProcessor;

    public void setHandlerConfiguration(@NonNull HandlerConfiguration handlerConfiguration) {
        Preconditions.checkNotNull((Object)handlerConfiguration, (Object)"handlerConfiguration is marked non-null but is null");
        this.handlerConfiguration = handlerConfiguration;
    }

    public void setNextProcessor(AbstractSingleItemProcessor<O> abstractSingleItemProcessor) {
        this.nextProcessor = abstractSingleItemProcessor;
    }

    public O process(String correlationId, I input) {
        O processingResult = this.processImpl(correlationId, input);
        if (this.nextProcessor == null) {
            return processingResult;
        }
        return this.nextProcessor.process(correlationId, processingResult);
    }

    public abstract O processImpl(String var1, I var2);

    @Generated
    protected AbstractTransformer(AbstractTransformerBuilder<I, O, ?, ?> b) {
        this.handlerConfiguration = b.handlerConfiguration;
        this.processorEventListener = b.processorEventListener;
        this.nextProcessor = b.nextProcessor;
    }

    @Generated
    public static abstract class AbstractTransformerBuilder<I, O, C extends AbstractTransformer<I, O>, B extends AbstractTransformerBuilder<I, O, C, B>> {
        @Generated
        private HandlerConfiguration handlerConfiguration;
        @Generated
        private ProcessorEventListener processorEventListener;
        @Generated
        private AbstractSingleItemProcessor<O> nextProcessor;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B handlerConfiguration(HandlerConfiguration handlerConfiguration) {
            this.handlerConfiguration = handlerConfiguration;
            return this.self();
        }

        @Generated
        public B processorEventListener(ProcessorEventListener processorEventListener) {
            this.processorEventListener = processorEventListener;
            return this.self();
        }

        @Generated
        public B nextProcessor(AbstractSingleItemProcessor<O> nextProcessor) {
            this.nextProcessor = nextProcessor;
            return this.self();
        }

        @Generated
        public String toString() {
            return "AbstractTransformer.AbstractTransformerBuilder(handlerConfiguration=" + this.handlerConfiguration + ", processorEventListener=" + this.processorEventListener + ", nextProcessor=" + this.nextProcessor + ")";
        }
    }
}

