/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;

public class PointFormatMapper
extends FormatMapper
implements FlatMapFunction<Iterator<String>, Point> {
    public PointFormatMapper(FileDataSplitter Splitter2, boolean carryInputData) {
        super(Splitter2, carryInputData);
    }

    public PointFormatMapper(Integer startOffset, Integer endOffset, FileDataSplitter Splitter2, boolean carryInputData) {
        super(startOffset, endOffset, Splitter2, carryInputData);
    }

    public Iterator<Point> call(Iterator<String> stringIterator) throws Exception {
        ArrayList<Point> result = new ArrayList<Point>();
        block4: while (stringIterator.hasNext()) {
            String line = stringIterator.next();
            switch (this.splitter) {
                case GEOJSON: {
                    Geometry geometry = this.readGeoJSON(line);
                    this.addGeometry(geometry, result);
                    continue block4;
                }
                case WKT: {
                    Geometry geometry = this.readWkt(line);
                    this.addGeometry(geometry, result);
                    continue block4;
                }
            }
            String[] columns = line.split(this.splitter.getDelimiter());
            Coordinate coordinate = new Coordinate(Double.parseDouble(columns[this.startOffset]), Double.parseDouble(columns[1 + this.startOffset]));
            Point point = this.factory.createPoint(coordinate);
            if (this.carryInputData) {
                point.setUserData(line);
            }
            result.add(point);
        }
        return result.iterator();
    }

    private void addGeometry(Geometry geometry, List<Point> result) {
        if (geometry instanceof MultiPoint) {
            this.addMultiGeometry((MultiPoint)geometry, result);
        } else {
            result.add((Point)geometry);
        }
    }
}

