/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;

public class PolygonFormatMapper
extends FormatMapper
implements FlatMapFunction<Iterator<String>, Polygon> {
    public PolygonFormatMapper(FileDataSplitter Splitter2, boolean carryInputData) {
        super(Splitter2, carryInputData);
    }

    public PolygonFormatMapper(Integer startOffset, Integer endOffset, FileDataSplitter Splitter2, boolean carryInputData) {
        super(startOffset, endOffset, Splitter2, carryInputData);
    }

    public Iterator<Polygon> call(Iterator<String> stringIterator) throws Exception {
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        block4: while (stringIterator.hasNext()) {
            String line = stringIterator.next();
            switch (this.splitter) {
                case GEOJSON: {
                    Geometry geometry = this.readGeoJSON(line);
                    this.addGeometry(geometry, result);
                    continue block4;
                }
                case WKT: {
                    Geometry geometry = this.readWkt(line);
                    this.addGeometry(geometry, result);
                    continue block4;
                }
            }
            Coordinate[] coordinates = this.readCoordinates(line);
            LinearRing linearRing = this.factory.createLinearRing(coordinates);
            Polygon polygon = this.factory.createPolygon(linearRing);
            if (this.carryInputData) {
                polygon.setUserData(line);
            }
            result.add(polygon);
        }
        return result.iterator();
    }

    private void addGeometry(Geometry geometry, List<Polygon> result) {
        if (geometry instanceof MultiPolygon) {
            this.addMultiGeometry((MultiPolygon)geometry, result);
        } else {
            result.add((Polygon)geometry);
        }
    }
}

