/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;

public class RectangleFormatMapper
extends FormatMapper
implements FlatMapFunction<Iterator<String>, Polygon> {
    public RectangleFormatMapper(FileDataSplitter Splitter2, boolean carryInputData) {
        super(Splitter2, carryInputData);
    }

    public RectangleFormatMapper(Integer startOffset, Integer endOffset, FileDataSplitter Splitter2, boolean carryInputData) {
        super(startOffset, endOffset, Splitter2, carryInputData);
    }

    public Iterator<Polygon> call(Iterator<String> stringIterator) throws Exception {
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        block4: while (stringIterator.hasNext()) {
            Coordinate[] coordinates;
            String line = stringIterator.next();
            switch (this.splitter) {
                case GEOJSON: {
                    Geometry geometry = this.readGeoJSON(line);
                    this.addGeometry(geometry, result);
                    continue block4;
                }
                case WKT: {
                    Geometry geometry = this.readWkt(line);
                    this.addGeometry(geometry, result);
                    continue block4;
                }
            }
            String[] columns = line.split(this.splitter.getDelimiter());
            double x1 = Double.parseDouble(columns[this.startOffset]);
            double x2 = Double.parseDouble(columns[this.startOffset + 2]);
            double y1 = Double.parseDouble(columns[this.startOffset + 1]);
            double y2 = Double.parseDouble(columns[this.startOffset + 3]);
            coordinates = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x1, y2), new Coordinate(x2, y2), new Coordinate(x2, y1), coordinates[0]};
            LinearRing linear = this.factory.createLinearRing(coordinates);
            Polygon polygon = new Polygon(linear, null, this.factory);
            if (this.carryInputData) {
                polygon.setUserData(line);
            }
            result.add(polygon);
        }
        return result.iterator();
    }

    private void addGeometry(Geometry geometry, List<Polygon> result) {
        if (geometry instanceof MultiPolygon) {
            this.addMultiGeometry((MultiPolygon)geometry, result);
        } else {
            result.add((Polygon)geometry.getEnvelope());
        }
    }
}

