/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.datasyslab.geospark.formatMapper.shapefileParser.boundary.BoundBox;
import org.datasyslab.geospark.formatMapper.shapefileParser.boundary.BoundaryInputFormat;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.PrimitiveShape;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShapeInputFormat;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShapeKey;
import org.datasyslab.geospark.spatialRDD.LineStringRDD;
import org.datasyslab.geospark.spatialRDD.PointRDD;
import org.datasyslab.geospark.spatialRDD.PolygonRDD;
import scala.Tuple2;

public class ShapefileReader {
    public static JavaRDD<Geometry> readToGeometryRDD(JavaSparkContext sc, String inputPath) {
        return ShapefileReader.readShapefile(sc, inputPath, new GeometryFactory());
    }

    public static JavaRDD<Geometry> readToGeometryRDD(JavaSparkContext sc, String inputPath, GeometryFactory geometryFactory) {
        return ShapefileReader.readShapefile(sc, inputPath, geometryFactory);
    }

    private static JavaRDD<Geometry> readShapefile(JavaSparkContext sc, String inputPath, final GeometryFactory geometryFactory) {
        JavaPairRDD shapePrimitiveRdd = sc.newAPIHadoopFile(inputPath, ShapeInputFormat.class, ShapeKey.class, PrimitiveShape.class, sc.hadoopConfiguration());
        return shapePrimitiveRdd.map((Function)new Function<Tuple2<ShapeKey, PrimitiveShape>, Geometry>(){

            public Geometry call(Tuple2<ShapeKey, PrimitiveShape> primitiveTuple) throws Exception {
                return ((PrimitiveShape)primitiveTuple._2()).getShape(geometryFactory);
            }
        });
    }

    public static BoundBox readBoundBox(JavaSparkContext sc, String inputPath) {
        JavaPairRDD bounds = sc.newAPIHadoopFile(inputPath, BoundaryInputFormat.class, Long.class, BoundBox.class, sc.hadoopConfiguration());
        if ((bounds = bounds.reduceByKey((Function2)new Function2<BoundBox, BoundBox, BoundBox>(){

            public BoundBox call(BoundBox box1, BoundBox box2) throws Exception {
                return BoundBox.mergeBoundBox(box1, box2);
            }
        })).count() > 0L) {
            return new BoundBox((BoundBox)((Tuple2)bounds.collect().get(0))._2());
        }
        return null;
    }

    public static PolygonRDD readToPolygonRDD(JavaSparkContext sc, String inputPath) {
        return ShapefileReader.geometryToPolygon(ShapefileReader.readToGeometryRDD(sc, inputPath));
    }

    public static PolygonRDD readToPolygonRDD(JavaSparkContext sc, String inputPath, GeometryFactory geometryFactory) {
        return ShapefileReader.geometryToPolygon(ShapefileReader.readToGeometryRDD(sc, inputPath, geometryFactory));
    }

    public static PolygonRDD geometryToPolygon(JavaRDD<Geometry> geometryRDD) {
        return new PolygonRDD((JavaRDD<Polygon>)geometryRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, Polygon>(){

            public Iterator<Polygon> call(Geometry spatialObject) throws Exception {
                ArrayList<Polygon> result = new ArrayList<Polygon>();
                if (spatialObject instanceof MultiPolygon) {
                    MultiPolygon multiObjects = (MultiPolygon)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        Polygon oneObject = (Polygon)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result.add(oneObject);
                    }
                } else if (spatialObject instanceof Polygon) {
                    result.add((Polygon)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getPolygonRDD] the object type is not Polygon or MultiPolygon type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        }));
    }

    public static PointRDD readToPointRDD(JavaSparkContext sc, String inputPath) {
        return ShapefileReader.geometryToPoint(ShapefileReader.readToGeometryRDD(sc, inputPath));
    }

    public static PointRDD readToPointRDD(JavaSparkContext sc, String inputPath, GeometryFactory geometryFactory) {
        return ShapefileReader.geometryToPoint(ShapefileReader.readToGeometryRDD(sc, inputPath, geometryFactory));
    }

    public static PointRDD geometryToPoint(JavaRDD<Geometry> geometryRDD) {
        return new PointRDD((JavaRDD<Point>)geometryRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, Point>(){

            public Iterator<Point> call(Geometry spatialObject) throws Exception {
                ArrayList<Point> result = new ArrayList<Point>();
                if (spatialObject instanceof MultiPoint) {
                    MultiPoint multiObjects = (MultiPoint)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        Point oneObject = (Point)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result.add(oneObject);
                    }
                } else if (spatialObject instanceof Point) {
                    result.add((Point)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getPointRDD] the object type is not Point or MultiPoint type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        }));
    }

    public static LineStringRDD readToLineStringRDD(JavaSparkContext sc, String inputPath) {
        return ShapefileReader.geometryToLineString(ShapefileReader.readToGeometryRDD(sc, inputPath));
    }

    public static LineStringRDD readToLineStringRDD(JavaSparkContext sc, String inputPath, GeometryFactory geometryFactory) {
        return ShapefileReader.geometryToLineString(ShapefileReader.readToGeometryRDD(sc, inputPath, geometryFactory));
    }

    public static LineStringRDD geometryToLineString(JavaRDD<Geometry> geometryRDD) {
        return new LineStringRDD((JavaRDD<LineString>)geometryRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, LineString>(){

            public Iterator<LineString> call(Geometry spatialObject) throws Exception {
                ArrayList<LineString> result = new ArrayList<LineString>();
                if (spatialObject instanceof MultiLineString) {
                    MultiLineString multiObjects = (MultiLineString)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        LineString oneObject = (LineString)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result.add(oneObject);
                    }
                } else if (spatialObject instanceof LineString) {
                    result.add((LineString)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getLineStringRDD] the object type is not LineString or MultiLineString type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        }));
    }
}

