/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.boundary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.datasyslab.geospark.formatMapper.shapefileParser.boundary.BoundBox;

public class BoundaryRecordReader
extends RecordReader<Long, BoundBox> {
    Path[] paths = null;
    long KEY_VALUE = 0L;
    FSDataInputStream inputStream = null;
    Configuration configuration = null;
    int id = -1;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        CombineFileSplit split = (CombineFileSplit)inputSplit;
        this.paths = split.getPaths();
        this.configuration = taskAttemptContext.getConfiguration();
        this.id = -1;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        ++this.id;
        return this.id < this.paths.length;
    }

    public Long getCurrentKey() throws IOException, InterruptedException {
        return this.KEY_VALUE;
    }

    public BoundBox getCurrentValue() throws IOException, InterruptedException {
        FileSystem fs = this.paths[this.id].getFileSystem(this.configuration);
        this.inputStream = fs.open(this.paths[this.id]);
        byte[] bytes = new byte[100];
        this.inputStream.readFully(bytes);
        this.inputStream.close();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.position(buffer.position() + 36);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        double[] bounds = new double[8];
        buffer.asDoubleBuffer().get(bounds);
        return new BoundBox(bounds);
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.id / (float)this.paths.length;
    }

    public void close() throws IOException {
    }
}

