/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.rangeJudgement;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.rangeJudgement.JudgementBase;

public class RangeFilterUsingIndex<U extends Geometry, T extends Geometry>
extends JudgementBase
implements FlatMapFunction<Iterator<SpatialIndex>, T> {
    public RangeFilterUsingIndex(U queryWindow, boolean considerBoundaryIntersection, boolean leftCoveredByRight) {
        super(queryWindow, considerBoundaryIntersection, leftCoveredByRight);
    }

    public Iterator<T> call(Iterator<SpatialIndex> treeIndexes) throws Exception {
        assert (treeIndexes.hasNext());
        SpatialIndex treeIndex = treeIndexes.next();
        ArrayList<Geometry> results = new ArrayList<Geometry>();
        List tempResults = treeIndex.query(this.queryGeometry.getEnvelopeInternal());
        for (Geometry tempResult : tempResults) {
            if (this.leftCoveredByRight) {
                if (!this.match(tempResult, this.queryGeometry)) continue;
                results.add(tempResult);
                continue;
            }
            if (!this.match(this.queryGeometry, tempResult)) continue;
            results.add(tempResult);
        }
        return results.iterator();
    }
}

