/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialOperator;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.datasyslab.geospark.enums.IndexType;
import org.datasyslab.geospark.enums.JoinBuildSide;
import org.datasyslab.geospark.geometryObjects.Circle;
import org.datasyslab.geospark.joinJudgement.DedupParams;
import org.datasyslab.geospark.joinJudgement.DynamicIndexLookupJudgement;
import org.datasyslab.geospark.joinJudgement.JudgementBase;
import org.datasyslab.geospark.joinJudgement.LeftIndexLookupJudgement;
import org.datasyslab.geospark.joinJudgement.NestedLoopJudgement;
import org.datasyslab.geospark.joinJudgement.RightIndexLookupJudgement;
import org.datasyslab.geospark.monitoring.GeoSparkMetric;
import org.datasyslab.geospark.monitoring.GeoSparkMetrics;
import org.datasyslab.geospark.spatialPartitioning.SpatialPartitioner;
import org.datasyslab.geospark.spatialRDD.CircleRDD;
import org.datasyslab.geospark.spatialRDD.SpatialRDD;
import scala.Tuple2;

public class JoinQuery {
    private static final Logger log = LogManager.getLogger(JoinQuery.class);

    private static <U extends Geometry, T extends Geometry> void verifyCRSMatch(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD) throws Exception {
        if (spatialRDD.getCRStransformation() != queryRDD.getCRStransformation()) {
            throw new IllegalArgumentException("[JoinQuery] input RDD doesn't perform necessary CRS transformation. Please check your RDD constructors.");
        }
        if (spatialRDD.getCRStransformation() && queryRDD.getCRStransformation() && !spatialRDD.getTargetEpgsgCode().equalsIgnoreCase(queryRDD.getTargetEpgsgCode())) {
            throw new IllegalArgumentException("[JoinQuery] the EPSG codes of two input RDDs are different. Please check your RDD constructors.");
        }
    }

    private static <U extends Geometry, T extends Geometry> void verifyPartitioningMatch(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD) throws Exception {
        int queryNumPart;
        Objects.requireNonNull(spatialRDD.spatialPartitionedRDD, "[JoinQuery] spatialRDD SpatialPartitionedRDD is null. Please do spatial partitioning.");
        Objects.requireNonNull(queryRDD.spatialPartitionedRDD, "[JoinQuery] queryRDD SpatialPartitionedRDD is null. Please use the spatialRDD's grids to do spatial partitioning.");
        SpatialPartitioner spatialPartitioner = spatialRDD.getPartitioner();
        SpatialPartitioner queryPartitioner = queryRDD.getPartitioner();
        if (!queryPartitioner.equals(spatialPartitioner)) {
            throw new IllegalArgumentException("[JoinQuery] queryRDD is not partitioned by the same grids with spatialRDD. Please make sure they both use the same grids otherwise wrong results will appear.");
        }
        int spatialNumPart = spatialRDD.spatialPartitionedRDD.getNumPartitions();
        if (spatialNumPart != (queryNumPart = queryRDD.spatialPartitionedRDD.getNumPartitions())) {
            throw new IllegalArgumentException("[JoinQuery] numbers of partitions in queryRDD and spatialRDD don't match: " + queryNumPart + " vs. " + spatialNumPart + ". Please make sure they both use the same partitioning otherwise wrong results will appear.");
        }
    }

    private static <U extends Geometry, T extends Geometry> JavaPairRDD<U, HashSet<T>> collectGeometriesByKey(JavaPairRDD<U, T> input) {
        return input.aggregateByKey(new HashSet(), new Function2<HashSet<T>, T, HashSet<T>>(){

            public HashSet<T> call(HashSet<T> ts, T t) throws Exception {
                ts.add(t);
                return ts;
            }
        }, new Function2<HashSet<T>, HashSet<T>, HashSet<T>>(){

            public HashSet<T> call(HashSet<T> ts, HashSet<T> ts2) throws Exception {
                ts.addAll(ts2);
                return ts;
            }
        });
    }

    private static <U extends Geometry, T extends Geometry> JavaPairRDD<U, Long> countGeometriesByKey(JavaPairRDD<U, T> input) {
        return input.aggregateByKey((Object)0L, new Function2<Long, T, Long>(){

            public Long call(Long count, T t) throws Exception {
                return count + 1L;
            }
        }, (Function2)new Function2<Long, Long, Long>(){

            public Long call(Long count1, Long count2) throws Exception {
                return count1 + count2;
            }
        });
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, HashSet<T>> SpatialJoinQuery(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection, false);
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, HashSet<T>> SpatialJoinQuery(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, HashSet<T>> SpatialJoinQueryWithDuplicates(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection, true);
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, HashSet<T>> SpatialJoinQueryWithDuplicates(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, T> SpatialJoinQueryFlat(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams params = new JoinParams(useIndex, considerBoundaryIntersection, false);
        return JoinQuery.spatialJoin(queryRDD, spatialRDD, params);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, T> SpatialJoinQueryFlat(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, JoinParams joinParams) throws Exception {
        return JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, Long> SpatialJoinQueryCountByKey(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection, false);
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, Long> SpatialJoinQueryCountByKey(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, T> DistanceJoinQueryFlat(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection, false);
        return JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, T> DistanceJoinQueryFlat(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        return JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, HashSet<T>> DistanceJoinQuery(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection, false);
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, HashSet<T>> DistanceJoinQuery(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, HashSet<T>> DistanceJoinQueryWithDuplicates(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection, true);
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, HashSet<T>> DistanceJoinQueryWithDuplicates(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, Long> DistanceJoinQueryCountByKey(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection, false);
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, Long> DistanceJoinQueryCountByKey(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, T> distanceJoin(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<Circle, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return joinResults.mapToPair(new PairFunction<Tuple2<Circle, T>, Geometry, T>(){

            public Tuple2<Geometry, T> call(Tuple2<Circle, T> circleTTuple2) throws Exception {
                return new Tuple2((Object)((Circle)circleTTuple2._1()).getCenterGeometry(), circleTTuple2._2());
            }
        });
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, T> spatialJoin(SpatialRDD<U> leftRDD, SpatialRDD<T> rightRDD, JoinParams joinParams) throws Exception {
        JavaRDD resultWithDuplicates;
        JudgementBase judgement;
        JoinQuery.verifyCRSMatch(leftRDD, rightRDD);
        JoinQuery.verifyPartitioningMatch(leftRDD, rightRDD);
        SparkContext sparkContext = leftRDD.spatialPartitionedRDD.context();
        GeoSparkMetric buildCount = GeoSparkMetrics.createMetric(sparkContext, "buildCount");
        GeoSparkMetric streamCount = GeoSparkMetrics.createMetric(sparkContext, "streamCount");
        GeoSparkMetric resultCount = GeoSparkMetrics.createMetric(sparkContext, "resultCount");
        GeoSparkMetric candidateCount = GeoSparkMetrics.createMetric(sparkContext, "candidateCount");
        SpatialPartitioner partitioner = (SpatialPartitioner)rightRDD.spatialPartitionedRDD.partitioner().get();
        DedupParams dedupParams = partitioner.getDedupParams();
        if (joinParams.useIndex) {
            if (rightRDD.indexedRDD != null) {
                judgement = new RightIndexLookupJudgement(joinParams.considerBoundaryIntersection, dedupParams);
                resultWithDuplicates = leftRDD.spatialPartitionedRDD.zipPartitions(rightRDD.indexedRDD, judgement);
            } else if (leftRDD.indexedRDD != null) {
                judgement = new LeftIndexLookupJudgement(joinParams.considerBoundaryIntersection, dedupParams);
                resultWithDuplicates = leftRDD.indexedRDD.zipPartitions(rightRDD.spatialPartitionedRDD, judgement);
            } else {
                log.warn((Object)"UseIndex is true, but no index exists. Will build index on the fly.");
                judgement = new DynamicIndexLookupJudgement(joinParams.considerBoundaryIntersection, joinParams.indexType, joinParams.joinBuildSide, dedupParams, buildCount, streamCount, resultCount, candidateCount);
                resultWithDuplicates = leftRDD.spatialPartitionedRDD.zipPartitions(rightRDD.spatialPartitionedRDD, judgement);
            }
        } else {
            judgement = new NestedLoopJudgement(joinParams.considerBoundaryIntersection, dedupParams);
            resultWithDuplicates = rightRDD.spatialPartitionedRDD.zipPartitions(leftRDD.spatialPartitionedRDD, judgement);
        }
        boolean uniqueResults = dedupParams != null;
        JavaRDD result = joinParams.allowDuplicates || uniqueResults ? resultWithDuplicates : resultWithDuplicates.distinct();
        return result.mapToPair(new PairFunction<Pair<U, T>, U, T>(){

            public Tuple2<U, T> call(Pair<U, T> pair) throws Exception {
                return new Tuple2(pair.getKey(), pair.getValue());
            }
        });
    }

    public static final class JoinParams {
        public final boolean useIndex;
        public final boolean considerBoundaryIntersection;
        public final boolean allowDuplicates;
        public final IndexType indexType;
        public final JoinBuildSide joinBuildSide;

        public JoinParams(boolean useIndex, boolean considerBoundaryIntersection, boolean allowDuplicates) {
            this.useIndex = useIndex;
            this.considerBoundaryIntersection = considerBoundaryIntersection;
            this.allowDuplicates = allowDuplicates;
            this.indexType = IndexType.RTREE;
            this.joinBuildSide = JoinBuildSide.RIGHT;
        }

        public JoinParams(boolean considerBoundaryIntersection, IndexType polygonIndexType, JoinBuildSide joinBuildSide) {
            this.useIndex = false;
            this.considerBoundaryIntersection = considerBoundaryIntersection;
            this.allowDuplicates = false;
            this.indexType = polygonIndexType;
            this.joinBuildSide = joinBuildSide;
        }
    }
}

