/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.datasyslab.geospark.enums.GridType;
import org.datasyslab.geospark.joinJudgement.DedupParams;
import org.datasyslab.geospark.spatialPartitioning.KDBTree;
import org.datasyslab.geospark.spatialPartitioning.SpatialPartitioner;
import org.datasyslab.geospark.utils.HalfOpenRectangle;
import scala.Tuple2;

public class KDBTreePartitioner
extends SpatialPartitioner {
    private final KDBTree tree;

    public KDBTreePartitioner(KDBTree tree) {
        super(GridType.KDBTREE, KDBTreePartitioner.getLeafZones(tree));
        this.tree = tree;
        this.tree.dropElements();
    }

    public int numPartitions() {
        return this.grids.size();
    }

    @Override
    public <T extends Geometry> Iterator<Tuple2<Integer, T>> placeObject(T spatialObject) throws Exception {
        Objects.requireNonNull(spatialObject, "spatialObject");
        Envelope envelope = spatialObject.getEnvelopeInternal();
        List<KDBTree> matchedPartitions = this.tree.findLeafNodes(envelope);
        Point point = spatialObject instanceof Point ? (Point)spatialObject : null;
        HashSet<Tuple2> result = new HashSet<Tuple2>();
        for (KDBTree leaf : matchedPartitions) {
            if (point != null && !new HalfOpenRectangle(leaf.getExtent()).contains(point)) continue;
            result.add(new Tuple2((Object)leaf.getLeafId(), spatialObject));
        }
        return result.iterator();
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        return new DedupParams(this.grids);
    }

    private static List<Envelope> getLeafZones(KDBTree tree) {
        final ArrayList<Envelope> leafs = new ArrayList<Envelope>();
        tree.traverse(new KDBTree.Visitor(){

            @Override
            public boolean visit(KDBTree tree) {
                if (tree.isLeaf()) {
                    leafs.add(tree.getExtent());
                }
                return true;
            }
        });
        return leafs;
    }
}

