/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.utils;

public class RDDSampleUtils {
    public static int getSampleNumbers(int numPartitions, long totalNumberOfRecords, int givenSampleNumbers) {
        if (givenSampleNumbers > 0) {
            if ((long)givenSampleNumbers > totalNumberOfRecords) {
                throw new IllegalArgumentException("[GeoSpark] Number of samples " + givenSampleNumbers + " cannot be larger than total records num " + totalNumberOfRecords);
            }
            return givenSampleNumbers;
        }
        if (totalNumberOfRecords < (long)(2 * numPartitions)) {
            throw new IllegalArgumentException("[GeoSpark] Number of partitions " + numPartitions + " cannot be larger than half of total records num " + totalNumberOfRecords);
        }
        if (totalNumberOfRecords < 1000L) {
            return (int)totalNumberOfRecords;
        }
        int minSampleCnt = numPartitions * 2;
        return (int)Math.max((long)minSampleCnt, Math.min(totalNumberOfRecords / 100L, Integer.MAX_VALUE));
    }
}

