/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX3D;
import org.opengis.geometry.BoundingBox3D;

public class BBOX3DImpl
implements BBOX3D {
    PropertyName property;
    ReferencedEnvelope3D envelope;
    FilterFactory factory;

    public BBOX3DImpl(PropertyName propertyName, ReferencedEnvelope3D env, FilterFactory factory) {
        this.property = propertyName;
        this.envelope = env;
        this.factory = factory;
    }

    @Override
    public double getMaxX() {
        return this.envelope.getMaxX();
    }

    @Override
    public double getMaxY() {
        return this.envelope.getMaxY();
    }

    @Override
    public double getMinX() {
        return this.envelope.getMinX();
    }

    @Override
    public double getMinY() {
        return this.envelope.getMinY();
    }

    public double getMinZ() {
        return this.envelope.getMinX();
    }

    public double getMaxZ() {
        return this.envelope.getMaxZ();
    }

    public PropertyName getProperty() {
        return this.property;
    }

    @Override
    public String getPropertyName() {
        return this.property.getPropertyName();
    }

    @Override
    public String getSRS() {
        return CRS.toSRS(this.envelope.getCoordinateReferenceSystem());
    }

    @Override
    public BoundingBox3D getBounds() {
        return this.envelope;
    }

    @Override
    public Expression getExpression1() {
        return this.property;
    }

    @Override
    public Expression getExpression2() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.envelope.getMinX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMinY())};
        LinearRing ring = null;
        GeometryFactory gfac = new GeometryFactory();
        try {
            ring = gfac.createLinearRing(coords);
        }
        catch (TopologyException tex) {
            throw new IllegalFilterException(tex.toString());
        }
        Polygon polygon = gfac.createPolygon(ring, null);
        if (this.envelope instanceof ReferencedEnvelope3D) {
            ReferencedEnvelope3D refEnv = this.envelope;
            polygon.setUserData(refEnv.getCoordinateReferenceSystem());
        }
        return this.factory.literal(polygon);
    }

    @Override
    public Object accept(FilterVisitor visitor, Object context) {
        return visitor.visit(this, context);
    }

    public ReferencedEnvelope3D get3DEnvelope(Geometry geom) {
        Coordinate[] coordinates = geom.getCoordinates();
        ReferencedEnvelope3D env = new ReferencedEnvelope3D();
        for (Coordinate coordinate : coordinates) {
            env.expandToInclude(coordinate);
        }
        return env;
    }

    @Override
    public boolean evaluate(Object feature) {
        Geometry other = Converters.convert(this.property.evaluate(feature), Geometry.class);
        if (other == null) {
            return false;
        }
        return this.get3DEnvelope(other).intersects(this.envelope);
    }

    public boolean isMatchingCase() {
        return false;
    }

    public boolean contains(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    public boolean evaluate(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return MultiValuedFilter.MatchAction.ANY;
    }

    public String toString() {
        return "BBOX3D [property=" + this.property + ", envelope=" + this.envelope + "]";
    }
}

