/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;

public class PolyLineParser
extends ShapeParser {
    public PolyLineParser(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    @Override
    public Geometry parseShape(ShapeReader reader) {
        reader.skip(32);
        int numParts = reader.readInt();
        int numPoints = reader.readInt();
        int[] offsets = this.readOffsets(reader, numParts, numPoints);
        LineString[] lines = new LineString[numParts];
        for (int i = 0; i < numParts; ++i) {
            int readScale = offsets[i + 1] - offsets[i];
            CoordinateSequence csString = this.readCoordinates(reader, readScale);
            lines[i] = this.geometryFactory.createLineString(csString);
        }
        if (numParts == 1) {
            return lines[0];
        }
        return this.geometryFactory.createMultiLineString(lines);
    }
}

